package com.yeejoin.amos.api.openapi.face.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.api.openapi.constant.Constant;
import com.yeejoin.amos.api.openapi.face.model.BizTokenModel;
import com.yeejoin.amos.api.openapi.face.model.SpecialCraneModel;
import com.yeejoin.amos.api.openapi.face.orm.dao.SpecialCraneMapper;
import com.yeejoin.amos.api.openapi.face.orm.entity.SpecialCrane;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.component.cache.Redis;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 起重机械 服务类
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@Component
public class SpecialCraneService extends BaseService<SpecialCraneModel, SpecialCrane, SpecialCraneMapper> {

        /**
         * 分页查询
         */
        public Page<SpecialCraneModel> queryForTmSpecialCranePage(Page page, String agencyCode) {
                return this.queryForPage(page, null, false, agencyCode);
        }

        /**
         * 列表查询 示例
         */
        public List<SpecialCraneModel> queryForTmSpecialCraneList(String agencyCode) {
                return this.queryForList("", false, agencyCode);
        }

		public String createSpecialCrane(List<SpecialCraneModel> model) {
			// TODO Auto-generated method stub
			if (ValidationUtil.isEmpty(model))
				throw new BadRequest("起重机械数据为空.");
	    	
			for (SpecialCraneModel specialCraneModel : model) {
				specialCraneModel.setRecDate(new Date());
				specialCraneModel.setAppId(getAppId());
				this.createWithModel(specialCraneModel);
			}
			return "OK";
			
		}
		private String getAppId() {
			String tokenKey = Redis.genKey(Constant.TOKEN_PREFIX,RequestContext.getToken());
	    	BizTokenModel bizTokenModel = (BizTokenModel) redisTemplate.opsForValue().get(tokenKey);
	    	return bizTokenModel.getAppId();
		}
	    @Autowired
	    private RedisTemplate redisTemplate;
}
