package com.yeejoin.equipmanage.common.datasync.enums;

import com.yeejoin.equipmanage.common.utils.finalString;

/**
 * <h1>同步数据类型</h1>
 *
 * @Author SingleTian
 * @Date 2021-04-01 09:20
 */
public enum SyncDataTypeEnum {


    /**
     * 巡检项
     */
    ASF_FIRE_PATROL_ITEM("11", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检点
     */
    ASF_FIRE_PATROL_POINT("12", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检点检查项
     */
    ASF_FIRE_PATROL_POINT_ITEM("60", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检路线
     */
    ASF_FIRE_PATROL_ROUTE("61", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检路线点
     */
    ASF_FIRE_PATROL_ROUTE_POINT("62", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检路线点检查项
     */
    ASF_FIRE_PATROL_ROUTE_POINT_ITEM("63", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检计划
     */
    ASF_FIRE_PATROL_PLAN("64", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检任务
     */
    ASF_FIRE_PATROL_PLAN_TASK("65", finalString.URL, finalString.ISNOTIOT),
    /**
     * 任务详情
     */
    ASF_FIRE_PATROL_PLAN_TASK_DETAIL("66", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡检记录
     */
    ASF_FIRE_PATROL_CHECK_RECORD("67", finalString.URL, finalString.ISNOTIOT),
    /**
     * 巡查记录详情
     */
    ASF_FIRE_PATROL_CHECK_RECORD_DETAIL("68", finalString.URL, finalString.ISNOTIOT),
    /**
     *  区域
     */
    AST_AREA("01", finalString.URLST, finalString.ISNOTIOT),
    /**
     *  建筑
     */
    AST_BUILDING("02", finalString.URLST, "building"),
    /**
     *  围墙
     */
    AST_WALL("03", finalString.URLST, finalString.ISNOTIOT),
    /**
     *  楼层
     */
    AST_FLOOR("04", finalString.URLST, "floor"),
    /**
     *  小室
     */
    AST_ROOM("05", finalString.URLST, "room"),
    /**
     *  消防系统
     */
    AST_FIRE_FIGHTING("07", finalString.URLST, finalString.ISNOTIOT),
    /**
     * 消防设备
     */
    AST_FIRE_EQUIP("08", finalString.URLST, finalString.ISNOTIOT),
    /**
     * 消防设备参数信息
     */
    AST_FIRE_EQUIP_INFO("0801", finalString.URLST, finalString.ISNOTIOT),
    /**
     * 消防设备量测信息
     */
    AST_FIRE_EQUIP_MEASUREMENT("0802", finalString.URLST, "isIot"),
    /**
     * 消防设备火警
     */
    AST_FIRE_EQUIP_ALARM("0803", finalString.URL, finalString.ISNOTIOT),
    /**
     * 消防设备故障
     */
    AST_FIRE_EQUIP_FAULT_ALARM("0804", finalString.URL, finalString.ISNOTIOT),
    /**
     * 消防设备缺陷
     */
    AST_FIRE_EQUIP_DEFECT_ALARM("0805", finalString.URL, finalString.ISNOTIOT),
    /**
     * 消防车辆
     */
    AST_FIRE_VEHICLE("09", finalString.URLST, finalString.ISNOTIOT),
    /**
     * 消防车辆参数信息
     */
    AST_FIRE_VEHICLE_INFO("0901", finalString.URLST, finalString.ISNOTIOT),
    /**
     * 消防车辆量测信息
     */
    AST_FIRE_VEHICLE_MEASUREMENT("0902", finalString.URLST, "isIot");

    /**
     * 资源类型编码
     */
    private final String sourceCode;
    /** mqtt主题 */
    private final String mqTopic;
    /** 装备物连属性 */
    private final String sign;

    SyncDataTypeEnum(String sourceCode, String mqTopic, String sign) {
        this.sourceCode = sourceCode;
        this.mqTopic = mqTopic;
        this.sign = sign;
    }

    public String getSourceCode() {
        return sourceCode;
    }

    public String getMqTopic() {
        return mqTopic;
    }

    public String getSign() {
        return sign;
    }

}
