package com.yeejoin.equipmanage.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.equipmanage.common.entity.publics.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 
 * <pre>
 * 在岗监测事件
 * </pre>
 *
 * @author gwb
 * @version $Id: MonitorEvent.java, v 0.1 2021年9月10日 下午3:19:23 gwb Exp $
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("wl_monitor_event")
public class MonitorEvent extends BaseEntity
{

	private static final long serialVersionUID = -4149392979814811460L;

	/**
	 * 事件内容
	 */
	@TableField(value = "event_content")
	private String eventContent;

	/**
	 * 事件类型
	 */
	@TableField(value = "event_type")
	private String eventType;

	/**
	 * 摄像头设备id
	 */
	@TableField(value = "video_id")
	private Long videoId;

	/**
	 * 摄像头设备名称
	 */
	@TableField(value = "video_name")
	private String videoName;

	/**
	 * 摄像头设备编码
	 */
	@TableField(value = "video_code")
	private String videoCode;

	/**
	 * 摄像头设备位置
	 */
	@TableField(value = "video_position")
	private String videoPosition;

	/**
	 * 摄像头设备监控区域
	 */
	@TableField(value = "video_monitor_position")
	private String videoMonitorPosition;

	/**
	 * 事件状态
	 */
	@TableField(value = "event_state")
	private String eventState;

	/**
	 * 抓拍图片
	 */
	@TableField(value = "snap_pictures")
	private String snapPictures;
	
	/**
	 * 发生时间
	 */
	@TableField(value = "event_date")
	private Date eventDate;

	/**
	 * 值班人员，包括姓名、单位/部门、岗位
	 */
	@TableField(value = "onduty")
	private String onduty;

	/**
	 * 事件处理记录
	 */
	@TableField(value = "disposal_record")
	private String disposalRecord;

	/**
	 * 处理人id
	 */
	@TableField(value = "disposal_user_id")
	private String disposalUserId;

	/**
	 * 处置人姓名
	 */
	@TableField(value = "disposal_user_name")
	private String disposalUserName;

	/**
	 * 处理时间
	 */
	@TableField(value = "disposal_date")
	private Date disposalDate;

}
