package com.yeejoin.equipmanage.common.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author keyong
 * @title: EquipmentRiskTypeEnum
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2020/11/2 13:40
 */
@Getter
@AllArgsConstructor
public enum EquipmentRiskTypeEnum {
    QT("NORMAL", "其他", "1"),
    YXZT("RUNSTATE", "运行状态", "2"),
    GZ("BREAKDOWN", "故障", "3"),
    HZGJ("FIREALARM", "火灾告警", "4"),
    PB("SHIELD", "屏蔽", "5");

    private String code;
    private String type;
    private String stateCode;


    public static String getEquipmentRiskTypeEnumType(String code) {
        for (EquipmentRiskTypeEnum eenum : EquipmentRiskTypeEnum.values()) {
            if (code.equals(eenum.getCode())) {
                return eenum.getType();
            }
        }
        return null;
    }

}
