package com.yeejoin.amos.fas.dao.entity;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.List;

/**
 * The persistent class for the risk_source database table.
 * 
 */
@Entity
@Table(name = "f_risk_source")
@NamedQuery(name = "RiskSource.findAll", query = "SELECT r FROM RiskSource r")
public class RiskSource extends BasicEntity {
	private static final long serialVersionUID = 1L;

	private String code;
	/**
	 * 3维坐标
	 */
	private String position3d;

	/**
	 * 3维楼层
	 */
	private String floor3d;

	@Column(name = "is_indoor")
	private Boolean isIndoor;

	@Column(name = "create_by")
	private String createBy;

	private String name;

	@Column(name = "org_code")
	private String orgCode;

	@Column(name = "parent_id")
	private Long parentId;

	private String remark;

	@Column(name = "risk_level_id")
	private Long riskLevelId;

	@Column(name = "status")
	private String status;

	@Column(name = "is_region")
	private String isRegion;

	private BigDecimal rpn;

	private BigDecimal increment;

	/**
	 * ue4位置
	 */
	@Lob
	private String ue4Location;

	/**
	 * ue4旋转
	 */
	@Lob
	private String ue4Rotation;

	/**
	 * ue4缩放
	 */
	@Lob
	private String ue4Extent;
	
	/**
	 * 区域路径
	 */
	@Lob
	private String routePath;

	/**
	 * 同步源id
	 */
	private Long sourceId;

	public Long getSourceId() {
		return sourceId;
	}

	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}

	/**
	 * 闪烁频率
	 */
	@Column(name = "flicker_frequency")
	private Integer flickerFrequency;

	private List<Fmea> fmeaList;

	private List<RpnChangeLog> rpnChangeLogList;


	private BigDecimal rpni = new BigDecimal(0) ;

	public BigDecimal getRpni() {
		return rpni;
	}

	public void setRpni(BigDecimal rpni) {
		this.rpni = rpni;
	}

	public BigDecimal getIncrement() {
		return increment;
	}

	public Integer getFlickerFrequency() {
		return flickerFrequency;
	}

	public void setFlickerFrequency(Integer flickerFrequency) {
		this.flickerFrequency = flickerFrequency;
	}

	public void setIncrement(BigDecimal increment) {
		this.increment = increment;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getIsRegion() {
		return isRegion;
	}

	public void setIsRegion(String isRegion) {
		this.isRegion = isRegion;
	}

	public RiskSource() {
	}

	public String getCode() {
		return this.code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getCreateBy() {
		return this.createBy;
	}

	public void setCreateBy(String createBy) {
		this.createBy = createBy;
	}

	public String getName() {
		return this.name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public Long getParentId() {
		return this.parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getRemark() {
		return this.remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Long getRiskLevelId() {
		return this.riskLevelId;
	}

	public void setRiskLevelId(Long riskLevelId) {
		this.riskLevelId = riskLevelId;
	}

	public BigDecimal getRpn() {
		return this.rpn;
	}

	public void setRpn(BigDecimal rpn) {
		this.rpn = rpn;
	}

	@OneToMany(mappedBy = "riskSource", cascade = { CascadeType.REMOVE })
	public List<Fmea> getFmeaList() {
		return fmeaList;
	}

	public void setFmeaList(List<Fmea> fmeaList) {
		this.fmeaList = fmeaList;
	}

	@OneToMany(mappedBy = "riskSource", cascade = { CascadeType.REMOVE })
	public List<RpnChangeLog> getRpnChangeLogList() {
		return rpnChangeLogList;
	}

	public void setRpnChangeLogList(List<RpnChangeLog> rpnChangeLogList) {
		this.rpnChangeLogList = rpnChangeLogList;
	}

	public String getPosition3d() {
		return position3d;
	}

	public void setPosition3d(String position3d) {
		this.position3d = position3d;
	}

	public String getFloor3d() {
		return floor3d;
	}

	public void setFloor3d(String floor3d) {
		this.floor3d = floor3d;
	}

	public Boolean getIsIndoor() {
		return isIndoor;
	}

	public void setIsIndoor(Boolean isIndoor) {
		this.isIndoor = isIndoor;
	}

	@Column(name = "ue4_location")
	public String getUe4Location() {
		return ue4Location;
	}

	public void setUe4Location(String ue4Location) {
		this.ue4Location = ue4Location;
	}

	@Column(name = "ue4_rotation")
	public String getUe4Rotation() {
		return ue4Rotation;
	}

	public void setUe4Rotation(String ue4Rotation) {
		this.ue4Rotation = ue4Rotation;
	}

	@Column(name = "ue4_extent")
	public String getUe4Extent() {
		return ue4Extent;
	}

	public void setUe4Extent(String ue4Extent) {
		this.ue4Extent = ue4Extent;
	}

	/**
	 * @return the routePath
	 */
	@Column(name = "route_path")
	public String getRoutePath() {
		return routePath;
	}

	/**
	 * @param routePath the routePath to set
	 */
	public void setRoutePath(String routePath) {
		this.routePath = routePath;
	}

}