package com.yeejoin.amos.knowledgebase.face.model;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.foundation.utils.TreeNode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Collection;

/**
 * <p>
 * 标签分组
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class KnowledgeTagGroupModel extends BaseModel implements TreeNode<KnowledgeTagGroupModel,Long> {

        /**
         * 标签分类名称
         */

        private String groupName;
        /**
         * 父级分类id
         */
    private Long parentId;
        /**
         * 机构编号
         */
    private String agencyCode;



    private Collection<KnowledgeTagGroupModel> children;


    @Override
    public Long getMyParentId() {
        return this.parentId;
    }

    @Override
    public Long getMyId() {
        return this.sequenceNbr;
    }

    @Override
    public Collection<KnowledgeTagGroupModel> getChildren() {
        return children;
    }

    @Override
    public void setChildren(Collection<KnowledgeTagGroupModel> children) {
        this.children  = children;
    }

    @Override
    public int compareTo(KnowledgeTagGroupModel groupModel) {
        return this.getMyId().compareTo(groupModel.getMyId());
    }



}
