package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 人员体检信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("rpm_person_examination")
@ApiModel(value = "PersonExamination对象", description = "人员体检信息")
public class PersonExamination extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    private Long personId;
    @ApiModelProperty(value = "体检单位")
    private String examineCompany;
    @ApiModelProperty(value = "体检时间")
    private Date examineDate;

    @ApiModelProperty(value = "健康状态(0-健康、1-亚健康、2-不健康、3-其他)")
    private String healthStatus;
    @TableField(exist = false)
    private String healthStatusLabel;

    @ApiModelProperty(value = "附件")
    @TableField(exist = false)
    @ImagePrefix
    private List<PersonExaminationAttachment> attachment;
}
