package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 工时信息
 *
 * @author duanwei
 * @date 2020-07-01
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_person_working_hours")
@ApiModel(value = "PersonWorkingHours对象", description = "工时信息")
public class PersonWorkingHours extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value = "人员信息id")
    private Long personId;
    @ApiModelProperty(value = "工时")
    private Double workingHours;
    @ApiModelProperty(value = "日期")
    private Date date;
    @ApiModelProperty(value = "项目")
    private Long projectId;
}
