package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 项目历史轨迹
 *
 * @author duanwei
 * @date 2020-07-16
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_history")
@ApiModel(value = "ProjectHistory对象", description = "项目历史轨迹")
public class ProjectHistory extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目名称")
    private String name;

    @ApiModelProperty(value = "创建时间")
    private Date startTime;

    @ApiModelProperty(value = "结束时间")
    private Date endTime;

    @ApiModelProperty(value = "地区")
    private String region;

    @ApiModelProperty(value = "人员id")
    private Long personId;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "分包商ID")
    private Long companyId;


}
