package com.yeejoin.precontrol.common.entity.access;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.util.List;

@Data
public class DoorOpenAndShowTips {
	
	//提示类型 tips-显示提示语,voice-播放提示音,both-显示提示语并播放提示音
	@JSONField(name="Type")
	private String Type;
	
	//自定义语 "\n" 代表换行,至多5行,每行至多25个字节
	@JSONField(name="Customtip")
	private String Customtip;
	
	//自定义文字显示时间 2000ms
	@JSONField(name="Tipstime")
	private int Tipstime = 3000;
	
	//字体颜色 R,G,B,不透明度 [255,255,255,204]
	@JSONField(name="BorderColor")
	private List<Integer> BorderColor;
	
	//背景颜色 R,G,B,不透明度  [255,0,0,204]
	@JSONField(name="BackgroundColor")
	private List<Integer> BackgroundColor;
	
	//继电器序号 0\1
	@JSONField(name="DoorIndex")
	private int DoorIndex;
	
	//单位ms,开门延迟时间  0表示不开门 1000
	@JSONField(name="Opendelay")
	private int Opendelay = 1000;
}
