package com.yeejoin.precontrol.common.enums;

public enum ExamEnum {

	SEC_TRAIN("安全专项培训考试", 1L),

	SEC_MONTH_TRAIN("安全月培训考试", 2L),

	EMER_TRAIN("应急培训考试", 3L),

	SEC_PRODUCT_TRAIN("安全生产责任制培训考试", 4L),

	SEC_STANDARD_TRAIN("安全生产标准化培训考试", 5L),

	HEALTH_TRAIN("职业健康、能源节约、生态环境保护教育培训考试", 6L);

	private String label;
	private Long value;

	ExamEnum(String label, Long value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}

	public Long getValue() {
		return value;
	}

	public void setValue(Long value) {
		this.value = value;
	}

	public static String getLabelByValue(Long value) {
		String label = null;
		for (SexEum type : SexEum.values()) {
			if (type.getValue().equals(value)) {
				label = type.getLabel();
				break;
			}
		}
		return label;
	}
}
