package com.yeejoin.precontrol.common.enums;

/*
 * sqy
 * 合同期限类型
 */
public enum ExpiryTypeEum {
    /*
     * 有固定期限
     */
    有固定期限("有固定期限", "0"),
    /*
     * 无固定期限
     */
    无固定期限("无固定期限", "1"),
    /**
     * 以任务为限
     */
    以任务为限("以任务为限", "2"),
    /**
     * 其他
     */
    其他("其他", "3");

    private String label;
    private String value;

    ExpiryTypeEum(String label, String value) {
        this.label = label;
        this.value = value;
    }

    public String getLabel() {
        return label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static String getLabelByValue(String value) {
        String label = null;
        for (ExpiryTypeEum type : ExpiryTypeEum.values()) {
            if (type.getValue().equals(value)) {
                label = type.getLabel();
                break;
            }
        }
        return label;
    }
}
