package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.precontrol.common.dto.ProjectDto;
import com.yeejoin.precontrol.common.entity.Project;
import com.yeejoin.precontrol.common.vo.BadProjectVo;
import com.yeejoin.precontrol.common.vo.ProjectVo;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

/**
 * 项目信息 Mapper 接口
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface ProjectMapper extends BaseMapper<Project> {

    IPage<ProjectVo> listByPage(IPage<ProjectVo> page, @Param("projectDto") ProjectDto projectDto);

    List<HashMap<String, Object>> projectSelect();

    List<BadProjectVo> badProject(IPage<BadProjectVo> page, @Param("isBad") boolean isBad,
                                  @Param("isAllStatus") boolean isAllStatus, @Param("badProjectVo") BadProjectVo badProjectVo);
}
