package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.entity.CompanyEvaluationLog;
import com.yeejoin.precontrol.common.vo.CompanyEvaluationLogVo;

import java.util.List;

/**
 * 分包商评价记录表 服务类
 *
 * @author duanwei
 * @date 2021-01-28
 */
public interface ICompanyEvaluationLogService extends IService<CompanyEvaluationLog> {

    /**
     * 根据被评价人id获取列表记录
     *
     * @param companyId 分包商id
     * @return
     */
    IPage<CompanyEvaluationLog> listByCompanyId(String pageNum, String pageSize, String companyId);

    /**
     * 根据被评价人id获取列表记录
     *
     * @param companyId 分包商id
     * @return
     */
    IPage<CompanyEvaluationLogVo> listVoByCompanyId(String pageNum, String pageSize, String companyId);


    /**
     * 根据任务id查询评价记录
     *
     * @param taskId
     * @return
     */
    List<CompanyEvaluationLog> listByTaskId(String taskId);
}
