package com.yeejoin.precontrol.common.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.precontrol.common.entity.RiskWork;
import com.yeejoin.precontrol.common.param.RiskWorkParam;
import com.yeejoin.precontrol.common.vo.RiskWorkPersonVo;
import com.yeejoin.precontrol.common.vo.RiskWorkVo;

import java.util.List;

/**
 * 风险作业管理表 服务类
 *
 * @author duanwei
 * @date 2021-01-28
 */
public interface IRiskWorkService extends IService<RiskWork> {
    /**
     * 作业活动保存
     *
     * @param riskWorkParam 业务对象
     * @param userId        userId
     * @return boolean
     */
    RiskWorkParam saveWithChild(RiskWorkParam riskWorkParam, String userId);

    /**
     * 删除
     *
     * @param ids 风险作业ids
     * @return boolean 是否成功
     */
    boolean removeWithChild(List<Long> ids);

    /**
     * 获取作业活动详情
     *
     * @param id 主键
     * @return
     */
    RiskWorkParam getWithChildById(Long id);

    /**
     * 获取符合作业条件的人
     *
     * @param riskWorkId 风险作业活动id
     * @param personType 人员类型
     * @param companyId  公司id
     * @param projectId  项目id
     * @param name 姓名 模糊查询
     * @return List<PersonVo>
     */
    List<RiskWorkPersonVo> listPersonOfMatchCondition(Long riskWorkId, String personType, Long companyId, Long projectId, String name);

    /**
     * 查询所有包括危险作业
     * @param name 风险作业名称
     * @return List<RiskWork>
     */
    List<RiskWork> listAllWithDangerWork(String name,String orgCode);

    /**
     * 根据风险计划id获取风险作业信息
     *
     * @param taskRiskControlId
     * @return
     */
    RiskWorkVo getDetailByPlanId(Long taskRiskControlId);
}
