package com.yeejoin.precontrol.common.vo;

import cn.afterturn.easypoi.excel.annotation.Excel;
import com.yeejoin.precontrol.common.annotations.TableFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 危险作业表Dto
 *
 * @author duanwei
 * @date 2020-08-24
 */
@ApiModel(value = "HazardousWork对象", description = "危险作业表")
@Data
public class HazardousWorkPageVo {

    private static final long serialVersionUID = 1L;

    private Long id;

    @ApiModelProperty(value = "危险作业名称")
    @Excel(name = "危险作业名称")
    private String name;

    @ApiModelProperty(value = "作业条件_输入项")
    @Excel(name = "作业条件")
    private String conditions;

    @ApiModelProperty(value = "描述")
    private String remark;

    @ApiModelProperty(value = "编号")
    @Excel(name = "编号")
    private String orderNo;

    @ApiModelProperty(value = "创建人id")
    @TableFormat(entityName = "rpm_person", fieldName = "name", operFieldName = "createPersonName")
    private Long createPersonId;
    @Excel(name = "发布人")
    private String createPersonName;
    @Excel(name = "日期", exportFormat = "yyyy-MM-dd HH:mm:ss")
    private Date createDate;


}
