package com.yeejoin.amos.supervision.common.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 巡检点状态
 * @author maoying
 *
 */
public enum PointStatusEnum {
	 UNPLAN("未纳入巡检计划", "0", ""),
	 QUALIFIED("合格", "1", ""),
	 UNQUALIFIED("不合格", "2", "#DF7400"),
	 OMISSION("漏检", "3", "#FF0000");
	
	/**
	 * 名称
	 */
	private String name;

	/**
	 * 值
	 */
	private String code;
	
	/**
	 * 颜色
	 */
	private String color;

	private PointStatusEnum(String name, String code, String color) {
		this.name = name;
		this.code = code;
		this.color = color;
	}

	public static String getName(String code) {
		for (PointStatusEnum c : PointStatusEnum.values()) {
			if (c.getCode() == code) {
				return c.name;
			}
		}
		return null;
	}
	
	public static String getValue(String name) {
		for (PointStatusEnum c : PointStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c.getCode();
			}
		}
		return "";
	}

	public static PointStatusEnum getEnumByCode(String code) {
		for (PointStatusEnum c : PointStatusEnum.values()) {
			if (c.getCode().equals(code)) {
				return c;
			}
		}
		return null;
	}

	public static PointStatusEnum getEnumByName(String name) {
		for (PointStatusEnum c : PointStatusEnum.values()) {
			if (c.getName().equals(name)) {
				return c;
			}
		}
		return null;
	}
	
	public static List<String> getEnumNameList() {
		List<String> nameList = new ArrayList<String>();
		for (PointStatusEnum c: PointStatusEnum.values()) {
			nameList.add(c.getName());
		}
		return nameList;
	}
	
	public static List<Map<String,String>> getEnumList() {
		List<Map<String,String>> nameList = new ArrayList<>();
		for (PointStatusEnum c: PointStatusEnum.values()) {
			Map<String, String> map = new HashMap<String, String>();
			map.put("name", c.getName());
			map.put("value", c.getCode());
			map.put("color", c.getColor());
			nameList.add(map);
		}
		return nameList;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getColor() {
		return color;
	}

	public void setColor(String color) {
		this.color = color;
	}

}
