package com.yeejoin.amos.supervision.core.common.response;

import cn.afterturn.easypoi.excel.annotation.Excel;
import lombok.Data;

import java.util.Date;

@Data
public class DangerListResponse {

	/**
	 * 隐患id
	 */
	private Long dangerId;

	@Excel(name = "治理进度", orderNum = "1")
	private String dangerState;// 治理进度

	@Excel(name = "隐患名称", width = 20, orderNum = "2")
	private String dangerName;// 隐患名称

	@Excel(name = "隐患地点", width = 20, orderNum = "3")
	private String structureName;// 隐患地点

	private String dangerPosition;// 详细地址

	private String structureId;// 建筑Id

	@Excel(name = "隐患级别", orderNum = "4")
	private String dangerLevel;// 隐患级别

	@Excel(name = "治理方式", orderNum = "5")
	private String reformType;// 治理方式

	private Date deadlineDate;

	@Excel(name = "整改期限", width = 20, orderNum = "6")
	private String deadline;// 整改期限

	@Excel(name = "是否逾期", orderNum = "7")
	private String overtimeState;// 是否逾期


	@Excel(name = "隐患来源名称", width = 15, orderNum = "8")
	private String dangerTypeName;//隐患来源名称

	private String dangerType;//隐患来源


	/**
	 * 隐患流程id
	 */
	private String processInstanceId;

	/**
	 * 可执行人
	 */
	private String canExecuteUser;

	/**
	 * 隐患发现人
	 */
	private String discoverUser;

	/**
	 * 执行人
	 */
	private String executeUser;

	/**
	 * 问题描述
	 */
	@Excel(name = "问题描述", width = 35, orderNum = "9")
	private String problemDescription;

	/**
	 * 原因分析
	 */
	@Excel(name = "原因分析", width = 35, orderNum = "10")
	private String reasonAnalysis;

	/**
	 * 举一反三
	 */
	@Excel(name = "举一反三", width = 35, orderNum = "11")
	private String inferOtherThings;

	/**
	 * 备注
	 */
	@Excel(name = "备注", width = 35, orderNum = "12")
	private String remark;
}
