package com.yeejoin.amos.boot.module.ccs.biz.controller;

import java.text.ParseException;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.ccs.api.service.IEquipmentService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 电力设备资产
 *
 * @author system_generator
 * @date 2021-11-09
 */
@RestController
@Api(tags = "电力设备资产Api")
@RequestMapping(value = "/equipment")
public class EquipmentController extends BaseController {

    @Autowired
    IEquipmentService iEquipmentService;

   /**
    * 根据电力设备mrid获取设备信息
    * @param mrid
    * @return
    * @throws ParseException
    */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "根据电力设备mrid获取设备信息", notes = "根据电力设备mrid获取设备信息")
    @GetMapping(value = "/{mrid}/info")
    public ResponseModel getEquipmentByMrid(
            @ApiParam(value = "电力设备编号") @PathVariable String mrid) throws ParseException {
        return ResponseHelper.buildResponse(iEquipmentService.getEquipmentByMrid(mrid));
    }


}
