package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.CommonTree;
import com.yeejoin.equipmanage.mapper.CommonTreeMapper;
import com.yeejoin.equipmanage.service.ICommonTreeService;
import org.springframework.stereotype.Service;

import java.util.List;


/**
 * 通用树查询
 * @author DELL
 */
@Service
public class CommonTreeServiceImpl extends ServiceImpl<CommonTreeMapper, CommonTree> implements ICommonTreeService {

    @Override
    public List<CommonTree> listSpecial(String treeType) {
        QueryWrapper<CommonTree> wrapper = new QueryWrapper<>();
        wrapper.eq("tree_type",treeType);
        wrapper.orderByAsc("sort");
        return this.list(wrapper);
    }
}
