package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.equipmanage.common.entity.Warehouse;
import com.yeejoin.equipmanage.mapper.SearchMapper;
import com.yeejoin.equipmanage.service.ISearchService;
import com.yeejoin.equipmanage.service.IWarehouseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

@Service
public class SearchServiceImpl implements ISearchService {

	@Autowired
	private SearchMapper searchMapper;

	@Autowired
	private IWarehouseService warehouseService;

	@Override
	public IPage<Map<String, String>> universal(Long warehouseId, String keyword, Page<Map<String, String>> pageBean) {
		Warehouse warehouse = warehouseService.getById(warehouseId);
		String orgcode = warehouse.getOrgCode();
		List<Map<String, String>> list = searchMapper.universal(warehouseId, orgcode, keyword, pageBean.offset(),
				pageBean.getSize());
		IPage<Map<String, String>> page = new Page<Map<String, String>>(pageBean.getCurrent(), pageBean.getSize());
		page.setRecords(list);
		page.setTotal(0);
		return page;
	}

}
