package com.yeejoin.amos.fas.business.dao.mapper;

import com.yeejoin.amos.fas.business.bo.BindRegionBo;
import com.yeejoin.amos.fas.business.param.CommonPageInfoParam;
import com.yeejoin.amos.fas.core.common.response.RegionTreeResponse;
import com.yeejoin.amos.fas.core.common.response.RiskSourceTreeResponse;
import com.yeejoin.amos.fas.dao.entity.RiskSource;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface RiskSourceMapper extends BaseMapper {

    /**
     * 风险点查询，分页查询统计用
     *
     * @param param
     * @return
     */
    long countPageData(CommonPageInfoParam param);

    /**
     * 风险点分页查询queryForRiskSourceLevel
     *
     * @param param
     * @return
     */
    List<HashMap<String, Object>> queryRiskSourceByPage(CommonPageInfoParam param);


    List<Map> queryForRegion();

    List<Map> queryRPNReport();

    Map queryForRiseUp(@Param("startTime") String startTime, @Param("endTime") String endTime);

    Long countByParentIdAndIsRegion(@Param("riskSourceId") Long riskSourceId, @Param("isRegion") String isRegion);

    List<Map> queryForMatrix();

    List<RiskSourceTreeResponse> getRiskSources(String compCode);

    List<RiskSourceTreeResponse> getRiskSourcesEquipment();

//    List<RiskSource> queryByFireEqument(@Param("fireEquipmentId") Long fireEquipmentId);

//    List<RiskSource> queryByPoint(@Param("pointId") Long pointId);


    //厂区rpn，重点设备个数，风险点个数，巡检点个数
    Map<String, List> statistics3dCount();

    //消防设备按分类统计个数
    List<Map> statisticsEquipClassify();

    //风险点按级别统计个数
    List<Map> statisticsRiskLevel();

    //巡检点按状态统计个数
    List<Map> statisticsPointStatus();


    RiskSourceTreeResponse findRiskSourceDetatil(@Param("id") Long id);


    //风险点详情和级别
    Map queryForRiskSourceLevel(@Param("riskSourceId") Long riskSourceId);


    List<Map> queryForUnqualified(@Param("riskSourceId") Long riskSourceId);

    List<Map> queryForFmeaEquipAlarm(@Param("riskSourceId") Long riskSourceId);
    /**
     * 子节点的rpni
     *
     * @param parentId
     * @return
     */
    List<Map<String, BigDecimal>> queryForRiskSourceRpni(@Param("parentId") Long parentId);

    List<HashMap<String, Object>> queryRiskAreaRpn();


    List<RiskSource> queryByFactor(@Param("factorId") Long factorId);

    List<HashMap<String, Object>> queryRiskSourceSecondLevel(String compCode);

    List<RiskSourceTreeResponse> getRiskSourcesFireEquipmentByType(@Param("type") String[] type);

    List<RiskSourceTreeResponse> getCheckPointRiskSource();

    List<Map> queryContingencyWater();

    List<Map> queryFmeaByPointId(@Param("pointId") Long pointId);

    void updateRpn(RiskSource riskSource);

    void updateRpnForNull(RiskSource riskSource);

	List<RegionTreeResponse> getRegionList(String channelType,String orgCode);

	HashMap<String, Object> findRegionById(@Param("id")Long id,@Param("orgCode")String orgCode,@Param("channelType")String channelType);

	void batchSaveRegionUe4(List<BindRegionBo> regionBoList);
}
