package com.yeejoin.amos.knowledgebase.controller;

import com.yeejoin.amos.knowledgebase.face.service.TagValueService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.doc.TycloudResource;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

/**
 * <p>
 * 值标签的实例值 前端控制器
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */

@RestController
@TycloudResource(module = "knowledgebase", value = "tagvalue")
@RequestMapping(value = "/v1/tagvalue")
@Api(tags = "knowledgebase-值标签的实例值")
public class TagValueResource {

    private final Logger logger = LogManager.getLogger(TagValueResource.class);
    @Autowired
    private TagValueService tagValueService;
   
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取所有当前系统的值标签的实例值")
    @RequestMapping(value = "/getAll/tegartValue", method = RequestMethod.GET)
    public ResponseModel<Object> getAllTegartValue(@RequestParam String value) {
        return ResponseHelper.buildResponse(tagValueService.getAllTegartValue(value));
    }
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "获取所有当前系统的值标签的实例值")
    @RequestMapping(value = "/getOne/", method = RequestMethod.GET)
    public ResponseModel<Object> queryByInstance(@RequestParam Long id) {
        return ResponseHelper.buildResponse(tagValueService.queryByInstance(id));
    }
}
