package com.yeejoin.precontrol.controller;

import com.yeejoin.amos.feign.systemctl.Systemctl;
import com.yeejoin.amos.feign.systemctl.model.DictionarieValueModel;
import com.yeejoin.precontrol.common.utils.CommonResponseUtil;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

import java.util.List;

/**
 * 字典controller
 *
 * @author sqy
 */


@ApiIgnore
@RestController
@RequestMapping(value = "/dictionarie", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class DictionarieController {
    @RequestMapping(value = "/{dictCode}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据code查询字典", notes = "根据code查询字典")
    public Object getDictValues(@PathVariable String dictCode) {
        try {
            List<DictionarieValueModel> result = Systemctl.dictionarieClient.dictValues(dictCode).getResult();
            return result;
        } catch (Exception e) {
            return CommonResponseUtil.failure("查询失败");
        }
    }
}
