package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckReport;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckReportService;
import com.yeejoin.amos.boot.module.tdc.biz.service.impl.CheckReportImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * 校验报告
 * @author DELL
 */
@RestController
@Api(tags = "校验报告api")
@RequestMapping(value = "/report")
public class CheckReportController extends BaseController {

    @Autowired
    CheckReportService checkReportService;

    /**
     * 根据amosOrgCode查询
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "selectAll")
    @ApiOperation(httpMethod = "GET",value = "根据amosOrgCode查询模型列表",  notes = "根据amosOrgCode查询模型列表")
    public ResponseModel<IPage<CheckReport>> selectAll(int current, int size, String amosOrgCode) {

        return ResponseHelper.buildResponse(checkReportService.selectAll(current,size,amosOrgCode));
    }

    /**
     *
     * return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "getInfo")
    @ApiOperation(httpMethod = "GET",value = "厂站消防数据更新",  notes = "厂站消防数据更新")
    public ResponseModel<Map> getInfo(int pageNumber, int pageSize) {
        return ResponseHelper.buildResponse(checkReportService.getInfo(pageNumber,pageSize));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "createReport")
    @ApiOperation(httpMethod = "GET",value = "创建报告",  notes = "创建报告")
    public ResponseModel createReport(String batchNo) {
        AgencyUserModel userInfo = getUserInfo();
        checkReportService.createReport(batchNo, userInfo);
        return ResponseHelper.buildResponse(true);
    }

}
