package com.yeejoin.amos.boot.module.tzs.flc.api.dto;

import java.util.Date;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
/**
* 气瓶基本信息列表Dto
*
* @author duanwei
* @date 2022-08-11
*/
@Data
public class TzCylinderInfoDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    /**
    * id
    */
    private String sequenceNbr;

    @ApiModelProperty(value = "产权单位名称")
    /**
     * 产权单位名称
     */
    private String unitName;

    @ApiModelProperty(value = "设备品种")
    /**
     * 设备品种
     */
    private Integer cylinderVariety;

    @ApiModelProperty(value = "产品名称")
    /**
     * 产品名称
     */
    private String productName;

    @ApiModelProperty(value = "产品编号")
    /**
     * 产品编号
     */
    private String factoryNum;

    @ApiModelProperty(value = "单位内部编号")
    /**
     * 单位内部编号
     */
    private String unitInnerCode;

    @ApiModelProperty(value = "充装介质")
    /**
     * 充装介质
     */
    private String fillingMedia;

    @ApiModelProperty(value = "气瓶制造单位")
    /**
     * 气瓶制造单位
     */
    private String manufacturingUnit;

    @ApiModelProperty(value = "制造日期")
    /**
     * 制造日期
     */
    private String manufacturingDate;

    @ApiModelProperty(value = "气瓶状态")
    /**
     * 气瓶状态
     */
    private Integer cylinderStatus;

    @ApiModelProperty(value = "阀门制造单位")
    /**
     * 阀门制造单位
     */
    private String valveManufacturUnit;


}
