package com.yeejoin.amos.boot.module.tzs.flc.api.entity;

import java.util.Date;
import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

/**
 * 气瓶充装信息--充装前检查
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling")
@ApiModel(value="TzCylinderFilling对象", description="气瓶充装信息--充装前检查")
public class CylinderFilling extends BaseEntity {

    private static final long serialVersionUID = 1L;




    @ApiModelProperty(value = "充装前检查Id")
    private String fillingBeforeId;

    @ApiModelProperty(value = "充装企业名称")
    private String fillingUnitName;

    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "是否在检验有效期以内")
    private String isValid;

    @ApiModelProperty(value = "警示标签上印有的瓶装气体的名称及化学分子式应与气瓶钢印标志是否一致")
    private Integer same;

    @ApiModelProperty(value = "气瓶外表面的颜色标志是否符合规定")
    private Integer isRegulations;

    @ApiModelProperty(value = "气瓶瓶阀的出气口螺纹型式是否符合GB/T15383")
    @TableField("is_compliance_withGBT")
    private Integer isComplianceWithgbt;

    @ApiModelProperty(value = "气瓶内有无剩余压力")
    private Integer haveStillPressure;

    @ApiModelProperty(value = "气瓶外表面有无裂纹、严重腐蚀、明显变形及其他严重外部损伤缺陷")
    private Integer isComplete;

    @ApiModelProperty(value = "气瓶的安全附件齐全并符合安全要求")
    private Integer haveSecurityDocuments;

    @ApiModelProperty(value = "检查人员姓名")
    private String inspectorUser;

    @ApiModelProperty(value = "检查时间")
    private String inspectionDate;



    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "新投入使用气瓶或经检验后首次投入使用气瓶，充装前应按照规定先置换瓶内空气，并经分析合格后方可充气")
    private String fillBeforeItem;

    @ApiModelProperty(value = "检查结果")
    private String checkResults;

    @ApiModelProperty(value = "不合格项")
    private String nonconformances;

}
