package com.yeejoin.equipmanage.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.equipmanage.common.datasync.entity.FireVehicle;
import com.yeejoin.equipmanage.common.dto.CarFusionDto;
import com.yeejoin.equipmanage.common.dto.CarInfoDto;
import com.yeejoin.equipmanage.common.dto.CarStatusInfoDto;
import com.yeejoin.equipmanage.common.entity.Car;
import com.yeejoin.equipmanage.common.entity.CarInfo;
import com.yeejoin.equipmanage.common.entity.CarProperty;
import com.yeejoin.equipmanage.common.entity.EquipmentCategory;
import com.yeejoin.equipmanage.common.entity.dto.CarDto;
import com.yeejoin.equipmanage.common.entity.vo.CarIndexVo;
import com.yeejoin.equipmanage.common.entity.vo.CarPropertyVo;
import com.yeejoin.equipmanage.common.vo.*;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 消防车信息 服务类
 *
 * @author wujiang
 * @date 2020-07-07
 */
public interface ICarService extends IService<Car> {

    List<EquipmentCategory> getCarCategory();

    Car saveCar(AgencyUserModel user, Car car, CarInfo carInfo, Set<CarProperty> carpList);

    /**
     * 消耗车载灭火剂
     */
    public Map<String, String> lossExtinguishants(Long carId, List<ExtinguishantLossRequest> extinguishants);

    /**
     *
     */
    public void loss(Object params);

    /**
     * 装载灭火剂
     */
    public Map<String, String> loadingExtinguishants(Long carId, List<ExtinguishantRequeset> extinguishants);

    /**
     * 装载装备
     */
    public void loadingEquipment(OnBoardEquipment equipment, AgencyUserModel user);

    /**
     * 卸载装备
     *
     * @return
     */
    public void unloadEquipment(OnBoardEquipment equipment, AgencyUserModel user);

    /**
     * 查询车辆列表
     */
    public IPage<Car> getCarList(String ercode, String orgcode, Car car, Page<Car> pageBean);

    /**
     * 查询车辆详情
     */
    Car selectOneById(Long id);

    /**
     * 根据id查询车辆详情信息
     */
    Car getCarDetailById(Long id);

    /**
     * 根据车牌号查询车辆详情信息
     */
    Car getCarDetailByCarNum(String carNum, String orgCode);
    
    /**
	 * 根据车辆id查询车辆详情信息
	 * @param id
	 * @param orgCode
	 * @param isIot
	 * @return
	 */
	CarForUE4VO getCarDetailByCarNumToThreeDimensional(Long id, String orgCode);


    /**
     * 添加车辆
     */
    Car saveOne(Car car);

    /**
     * 更新车辆
     */
    Car updateOneById(Car car);

    /**
     * 批量删除
     */
    boolean removeOneByIds(List<Long> idList);

    /**
     * 分页查询车辆
     */
    Page<Car> page(Page<Car> pageBean, Car car);

    /**
     * 获取车辆物联信息
     */
    List<CarIndexVo> getCarsIotInfo(String orgCode);

    /**
     * 根据车辆ID，获取车载装备及状态
     */
    List<EquipStateOnCarVo> getCarEquipmentsById(Long id);

    void dataSyncDeletedIds(List<Long> carIds);

    FireVehicle getFireVehicleDetailById(Long id);

    /**
     * 车辆详情接口
     * @return  List<CarInfoVo>
     * @param teamId 队伍id
     * @param name 车辆名称
     */
    List<CarInfoDto> carInfoList(Long teamId, String name);

    /**
     * 队伍车辆详情接口
     * @return  List<CarInfoVo>
     * @param teamId 队伍id
     * @param name 车辆名称
     */
    List<Map<String, Object>> teamCarList();

    /**
     * 更新车辆状态
     *
     * @param cars
     */
    Boolean updateCarStatus(List<CarStatusInfoDto> cars);

    List<CarDto> getTeamCarList(Long id, Double longitude, Double latitude);

    /**
     * 获取车辆属性集合值（参数均为非必填）
     * @param idList    车辆ID集合
     * @param teamId    队伍ID
     * @param nameKeys  属性编码，中间英文逗号隔开
     * @param isIot 是否物联，1：物联，0：非物联
     * @return
     */
    List<CarPropertyVo> getCarPropertyList(List<Long> idList, Long teamId, String nameKeys, Integer isIot);

    /**
     * 查询车辆简要信息
     */
    Car querySimpleInfoById(Long id);
    
    Object getCarStateInfoByCarNum(String carNum);

    Page<CarInfoDto>  equipmentCarList(Page<CarInfoDto> pag ,Long teamId, String name,String code,Long id,Boolean isNo);

    /**
     * 获取融合终端车辆列表
     * @return
     */
    List<CarFusionDto> getCarFusionList();

    /**
     * 更新redis 统计数据
     */
    void refreshStaData();
}
