package com.yeejoin.amos.patrol.business.util;

import com.yeejoin.amos.patrol.business.param.CheckInfoListPageParam;
import com.yeejoin.amos.patrol.business.param.CheckInfoPageParam;
import com.yeejoin.amos.patrol.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.core.common.request.CommonPageable;
import com.yeejoin.amos.patrol.core.common.request.CommonRequest;
import org.springframework.util.ObjectUtils;

import java.util.HashMap;
import java.util.List;

public class CheckPageParamUtil {

	public static CheckInfoPageParam fillCheckInfoParam(List<CommonRequest> queryRequests,
			CommonPageable commonPageable, HashMap<String, Object> perMap) {
		CheckInfoPageParam param = new CheckInfoPageParam();
		if(queryRequests!=null){
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("beginDate".equals(name)) {
				param.setBeginDate(toString(queryRequests.get(i).getValue()));
			} else if ("endDate".equals(name)) {
				param.setEndDate(toString(queryRequests.get(i).getValue()));
			} else if ("userName".equals(name)) {
				param.setUserName(toString(queryRequests.get(i).getValue()));
			} else if ("pointNo".equals(name)) {
				param.setPointNo(toString(queryRequests.get(i).getValue()));
			} else if ("pointName".equals(name)) {
				param.setPointName(toString(queryRequests.get(i).getValue()));
			} else if ("isFixed".equals(name)) {
				param.setIsFixed(toString(queryRequests.get(i).getValue()));
			} else if ("finishStatus".equals(name)) {
				param.setFinishStatus(toString(queryRequests.get(i).getValue()));
			} else if ("isOK".equals(name)) {
				param.setIsOK(toString(queryRequests.get(i).getValue()));
			} else if ("planTaskId".equals(name)) {
				param.setPlanTaskId(toString(queryRequests.get(i).getValue()));
			} else if ("routeId".equals(name)) {
				param.setRouteId(toString(queryRequests.get(i).getValue()));
			} else if ("catalogId".equals(name)) {
				param.setCatalogId(toString(queryRequests.get(i).getValue()));
			}else if ("orderBy".equals(name)) {
				param.setOrderBy(toString(queryRequests.get(i).getValue()));
			}else if ("userId".equals(name)) {
				param.setUserId(toString(queryRequests.get(i).getValue()));
			}else if ("pointId".equals(name)) {
				param.setPointId(toString(queryRequests.get(i).getValue()));
			}else if ("planType".equals(name)) {
				param.setPlanType(toString(queryRequests.get(i).getValue()));
			} else if ("checkType".equals(name)) {
				param.setCheckType(toString(queryRequests.get(i).getValue()));
			}  else if ("departmentId".equals(name)) {
				param.setDepartmentId(toString(queryRequests.get(i).getValue()));
			}else if ("planId".equals(name)) {
				param.setPlanId(toString(queryRequests.get(i).getValue()));
			}else if("checkTime".equals(name)) {
				param.setCheckTime(toString(queryRequests.get(i).getValue()));
			} else if ("checkDeptId".equals(name)) {
				param.setCheckDeptId(toString(queryRequests.get(i).getValue()));
			} else if ("dangerId".equals(name)) {
				if(queryRequests.get(i).getValue()!=null) {
					param.setDangerId(Long.parseLong(queryRequests.get(i).getValue().toString()));
				}
			}else if ("dangerType".equals(name)) {
				if(queryRequests.get(i).getValue()!=null) {
					param.setDangerType(Integer.parseInt(queryRequests.get(i).getValue().toString()));
				}
			}

		}
		}
		if(param.getBeginDate() != null && param.getEndDate() == null){
			param.setEndDate(param.getBeginDate()+" 23:59:59");
			param.setBeginDate(param.getBeginDate()+" 00:00:00");
		}

		if(param.getBeginDate() != null && param.getBeginDate().length()==10){
			param.setBeginDate(param.getBeginDate()+" 00:00:00");
		}

		if(param.getEndDate() != null &&param.getEndDate().length()==10){
			param.setEndDate(param.getEndDate()+" 23:59:59");
		}
		param.setOrgCode(perMap.get("orgCode") == null ? null : perMap.get("orgCode").toString());
		if ("0".equals(perMap.get("roleFlag"))) {
			param.setUserId(perMap.get("userId") == null ? null : perMap.get("userId").toString());
		}
		if (commonPageable != null) {
			param.setPageNumber(commonPageable.getPageNumber());
			param.setPageSize(commonPageable.getPageSize());
		}
		return param;
	}

	public static HashMap<String, Object> fillInfo(List<CommonRequest> queryRequests) {
		HashMap<String, Object> param = new HashMap<String, Object>();
		if (ObjectUtils.isEmpty(queryRequests)) {
			return param;
		}
		for (CommonRequest request : queryRequests) {
			if (!ObjectUtils.isEmpty(request) && !ObjectUtils.isEmpty(request.getName())) {
				param.put(request.getName(), request.getValue());
			}
		}
		return param;
	}

	/**
	 * 巡检执行情况参数
	 *
	 * @param queryRequests
	 * @param commonPageable
	 * @param paramMap
	 * @return
	 */
	public static CheckPtListPageParam fillChkExParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
			HashMap<String, Object> roleMap) {
		CheckPtListPageParam param = new CheckPtListPageParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("checkDate".equals(name)) {
				param.setCheckDate(toString(queryRequests.get(i).getValue()));
			}
		}
		param.setOrgCode(roleMap.get("orgCode") == null ? null : roleMap.get("orgCode").toString());
		param.setUserId(roleMap.get("userId") == null ? null : roleMap.get("userId").toString());
		param.setPageNumber(commonPageable.getPageNumber());
		param.setPageSize(commonPageable.getPageSize());
		return param;
	}

	/**
	 * 巡检点查询参数
	 *
	 * @param queryRequests
	 * @param commonPageable
	 * @param paramMap
	 * @return
	 */
	public static CheckPtListPageParam fillChkPtParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
			HashMap<String, Object> roleMap) {
		CheckPtListPageParam paramMap = new CheckPtListPageParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("checkType".equals(name)) {
				paramMap.setCheckType(toString(queryRequests.get(i).getValue()));
			} else if ("checkStatus".equals(name)) {
				paramMap.setCheckStatus(toString(queryRequests.get(i).getValue()));
			} else if ("deptId".equals(name)) {
				paramMap.setGroupId(toString(queryRequests.get(i).getValue()));
			} else if ("userId".equals(name)) {
				paramMap.setUserId(toString(queryRequests.get(i).getValue()));
			} else if ("name".equals(name)) {
				paramMap.setName(toString(queryRequests.get(i).getValue()));
			} else if ("companyId".equals(name)) {
				paramMap.setCompanyId(toString(queryRequests.get(i).getValue()));
			} else if ("pointLevel".equals(name)) {
				paramMap.setLevel(toString(queryRequests.get(i).getValue()));
			} else if ("pointID".equals(name)) {
				paramMap.setPointId(toInteger(queryRequests.get(i).getValue()));
			}
		}
		if(null != commonPageable){
			paramMap.setPageNumber(commonPageable.getPageNumber());
			paramMap.setPageSize(commonPageable.getPageSize());
		}
		paramMap.setOrgCode(roleMap.get("orgCode") == null ? null : roleMap.get("orgCode").toString());
//		paramMap.setUserId(roleMap.get("userId") == null ? null : roleMap.get("userId").toString());
		return paramMap;
	}

	/**
	 * 巡检轨迹参数
	 *
	 * @param queryRequests
	 * @param commonPageable
	 * @param params
	 * @return
	 */
	public static CheckPtListPageParam fillTraParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
			HashMap<String, Object> params) {
		CheckPtListPageParam paramsMap = new CheckPtListPageParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("userId".equals(name)) {
				paramsMap.setUserId(toString(queryRequests.get(i).getValue()));
			} else if ("checkDate".equals(name)) {
				paramsMap.setCheckDate(toString(queryRequests.get(i).getValue()));
			} else if ("companyId".equals(name)) {
				paramsMap.setCompanyId(toString(queryRequests.get(i).getValue()));
			}
		}
		paramsMap.setOrgCode(params.get("orgCode") == null ? null : params.get("orgCode").toString());
		paramsMap.setPageNumber(commonPageable.getPageNumber());
		paramsMap.setPageSize(commonPageable.getPageSize());
		return paramsMap;
	}

	private static Integer toInteger(Object value) {
		if (null == value || value == "") {
			return null;
		} else {
			return Integer.valueOf(value.toString());
		}
	}

	private static String toString(Object value) {
		if (null == value || value == "") {
			return null;
		} else {
			return value.toString();
		}
	}

	public static CheckInfoListPageParam fillChkInfoListParam(List<CommonRequest> queryRequests, CommonPageable commonPageable,
			HashMap<String, Object> paramsMap) {
		CheckInfoListPageParam infoParams = new CheckInfoListPageParam();
		for (int i = 0; i < queryRequests.size(); i++) {
			String name = queryRequests.get(i).getName();
			if ("pointID".equals(name)) {
				infoParams.setPointID(toString(queryRequests.get(i).getValue()));
			} else if ("status".equals(name)) {
				infoParams.setStatus(toString(queryRequests.get(i).getValue()));
			} else if ("checkTime".equals(name)) {
				infoParams.setCheckTime(toString(queryRequests.get(i).getValue()));
			} else if ("userID".equals(name)) {
				infoParams.setUserID(toString(queryRequests.get(i).getValue()) == null ? -1
						: Integer.parseInt(toString(queryRequests.get(i).getValue())));
			} else if ("userName".equals(name)) {
				infoParams.setUserName(toString(queryRequests.get(i).getValue()));
			} else if ("pointName".equals(name)) {
				infoParams.setPointName(toString(queryRequests.get(i).getValue()));
			}
		}
		infoParams.setOrgCode(paramsMap.get("orgCode") == null ? null : paramsMap.get("orgCode").toString());
//		infoParams.setUserID(paramsMap.get("userId") == null ? -1 : Integer.parseInt(paramsMap.get("userId").toString()));
		infoParams.setPageNumber(commonPageable.getPageNumber());
		infoParams.setPageSize(commonPageable.getPageSize());
		return infoParams;
	}

}
