package com.yeejoin.precontrol.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.precontrol.common.dto.CommonPageableDto;
import com.yeejoin.precontrol.common.dto.StudioPageableDto;
import com.yeejoin.precontrol.common.entity.Retribution;
import com.yeejoin.precontrol.common.enums.TaskStatusEnum;
import com.yeejoin.precontrol.common.mapper.RetributionMapper;
import com.yeejoin.precontrol.common.service.IRetributionService;
import com.yeejoin.precontrol.common.vo.RetributionVo;
import com.yeejoin.precontrol.common.vo.RewardListVo;
import com.yeejoin.precontrol.common.vo.RewardOrgCodeVo;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 惩罚表 服务实现类
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Service
public class RetributionServiceImpl extends ServiceImpl<RetributionMapper, Retribution> implements IRetributionService {

	@Autowired
	private RetributionMapper retributionMapper;

	@Override
	public IPage<RetributionVo> pageInfo(CommonPageableDto pageable, RetributionVo retributionVo) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		Page<RetributionVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		List<RetributionVo> pageInfo = retributionMapper.pageInfo(retributionVo, page);
		pageInfo.forEach(p -> {
			if (p.getStatusCode() != null) {
				p.setStatusValue(TaskStatusEnum.getNameByType(Long.valueOf(p.getStatusCode())));
			}
		});
		page.setRecords(pageInfo);
		return page;
	}

	@Override
	public IPage<RewardOrgCodeVo> listPageComcany(StudioPageableDto pageable, String companyName, String orderType) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		return retributionMapper.listPageComcany(
				new Page<RewardOrgCodeVo>(pageable.getCurrent() - 1, pageable.getSize()), companyName, null, orderType);
	}

	@Override
	public IPage<RewardListVo> rewardUserListDetail(StudioPageableDto pageable, RewardListVo rewardVo) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		return retributionMapper
				.rewardUserListDetail(new Page<RewardListVo>(pageable.getCurrent() - 1, pageable.getSize()), rewardVo);
	}

	@Override
	public IPage<RewardOrgCodeVo> listBadPageCompany(StudioPageableDto pageable, RewardOrgCodeVo rewardOrgCodeVo,
			String orderType) {
		if (pageable.getCurrent() == null || pageable.getSize() == null) {
			pageable.setCurrent(0);
			pageable.setSize(Integer.MAX_VALUE);
		}
		if (!StringUtils.isEmpty(rewardOrgCodeVo.getSort())) {
			String[] s = rewardOrgCodeVo.getSort().split(",");
			rewardOrgCodeVo.setSortName(s[0]);
			rewardOrgCodeVo.setSortOrder(s[1]!=null?s[1].replace("end", ""):null);
		}
		return retributionMapper.listBadPageCompany(
				new Page<RewardOrgCodeVo>(pageable.getCurrent() - 1, pageable.getSize()), rewardOrgCodeVo, null,
				orderType);
	}

	@Override
	public IPage<RetributionVo> pageCompanyInfo(CommonPageableDto pageable, RetributionVo retributionVo) {
		if (pageable.getIsAll() == 1) {
			pageable.setPageNumber(0);
			pageable.setPageSize(Integer.MAX_VALUE);
		}
		if (!StringUtils.isEmpty(retributionVo.getSort())) {
			String[] s = retributionVo.getSort().split(",");
			retributionVo.setSortName(s[0]);
			retributionVo.setSortOrder(s[1]!=null?s[1].replace("end", ""):null);
		}
		Page<RetributionVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
		List<RetributionVo> pageInfo = retributionMapper.pageCompanyInfo(retributionVo, page);
		pageInfo.forEach(p -> {
			if (p.getStatusCode() != null) {
				p.setStatusValue(TaskStatusEnum.getNameByType(Long.valueOf(p.getStatusCode())));
			}
		});
		page.setRecords(pageInfo);
		return page;
	}

	@Override
	public Integer dayCountByOrgCode(String orgCode, Long projectId) {
		return retributionMapper.dayCountByOrgCode(orgCode, projectId);
	}

	@Override
	public Integer dayCompanyCountByOrgCode(String orgCode, Long projectId) {
		return retributionMapper.dayCompanyCountByOrgCode(orgCode, projectId);
	}
}
