package com.yeejoin.precontrol.common.task;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.precontrol.common.entity.Company;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.PersonAscription;
import com.yeejoin.precontrol.common.entity.PersonMessage;
import com.yeejoin.precontrol.common.enums.MessageSubTypeEnum;
import com.yeejoin.precontrol.common.enums.MessageTypeEnum;
import com.yeejoin.precontrol.common.mapper.CompanyMapper;
import com.yeejoin.precontrol.common.service.*;
import com.yeejoin.precontrol.common.utils.PersonUtils;
import com.yeejoin.precontrol.common.utils.StringUtil;
import com.yeejoin.precontrol.common.vo.CompanyVo;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @description: 分包商存在2个或以上的红码人员（未消除每日8点告警）
 * @author: duanwei
 * @date: 2020-08-07 14:06
 **/

@Component
@EnableScheduling
@Slf4j
public class BadPersonTask {

	@Autowired
	IProjectService iProjectService;

	@Autowired
	IProjectScoreService iProjectScoreService;

	@Autowired
	IPersonAscriptionService iPersonAscriptionService;

	@Autowired
	ICompanyService iCompanyService;

	@Autowired
	ITaskService iTaskService;

	@Autowired
	IPersonService iPersonService;

	@Autowired
	IPersonMessageService iPersonMessageService;

	@Autowired
	PersonUtils personUtils;

	@Autowired
	CompanyMapper companyMapper;

	/**
	 *
	 */
	@Scheduled(cron = "0 0 8 * * ?")
	public void scan() {
		log.info("分包商存在2个或以上的红码人员统计开始--------------->");
//        List<PersonAscription> list = iPersonAscriptionService.list();
//        List<Company> companyList = iCompanyService.list(new LambdaQueryWrapper<Company>().eq(Company::getTypeKey, 1));
//        Set<Long> collect = companyList.stream().map(result -> result.getId()).collect(Collectors.toSet());
//        Set<Long> companyIds = list.stream().map(result -> result.getCompanyId()).collect(Collectors.toSet());
//        // 红码人员告警，排除江西电建公司
//        companyIds.removeAll(collect);
//        companyIds.forEach(companyId -> {
//            //查出分包商的人员
//            List<PersonAscription> personAscriptionList = iPersonAscriptionService.list(new LambdaQueryWrapper<PersonAscription>()
//                    .select(PersonAscription::getPersonId)
//                    .eq(PersonAscription::getCompanyId, companyId));
//            Set<Long> userIds =
//                    personAscriptionList.stream().map(personAscription -> personAscription.getPersonId()).collect(Collectors.toSet());
//            if (StringUtil.isNotEmpty(userIds)) {
//                LambdaQueryWrapper<Person> personLambdaQueryWrapper = new LambdaQueryWrapper<>();
//                personLambdaQueryWrapper.eq(Person::getColor, 0L);
//                personLambdaQueryWrapper.in(Person::getId, userIds);
//                // 分包商风险预警，红码触发条件过滤掉通过考试不合格的红码人数
//                personLambdaQueryWrapper.ge(true,Person::getRedCount, 1);
//                List<Person> person = iPersonService.list(personLambdaQueryWrapper);
//                if (StringUtil.isNotEmpty(person)) {
//                    if (person.size() >= 2) {
//                        List<Long> platformSecurityPerson = personUtils.getPlatformSecurityPerson();
//                        if (StringUtil.isNotEmpty(platformSecurityPerson)) {
//                            for (Long personId : platformSecurityPerson) {
//                                savePersonMessage(companyId, personId);
//                            }
//                        }
//                    }
//                }
//            }
//        });
		List<CompanyVo> list = companyMapper.redPersonCompany(2);
		List<Long> platformSecurityPerson = personUtils.getPlatformSecurityPerson();
		for (CompanyVo companyVo : list) {
			for (Long personId : platformSecurityPerson) {
				savePersonMessage(companyVo.getId(), personId);
			}
		}
		log.info("分包商存在2个或以上的红码人员结束--------------->");
	}

	private void savePersonMessage(Long companyId, Long personId) {
		PersonMessage personMessage = new PersonMessage();
		personMessage.setType(MessageTypeEnum.COMPANY.getType());
		personMessage.setSubType(Long.valueOf(MessageSubTypeEnum.RED_COLOR.getType()));
		personMessage.setPersonId(personId);
		personMessage.setContent("分包商风险预警");
		personMessage.setReadStatus(0);
		personMessage.setObjectId(companyId);
		iPersonMessageService.save(personMessage);
	}

}
