package com.yeejoin.equipmanage.controller;

import com.yeejoin.equipmanage.common.entity.FormGroupColumn;
import com.yeejoin.equipmanage.common.entity.dto.FormGroupColumnDto;
import com.yeejoin.equipmanage.service.IFormGroupColumnService;
import com.yeejoin.equipmanage.service.IFormInstanceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;

import java.util.List;


/**
 * 动态表单控制器
 *
 * @author gaojianqiang
 * @date 2022-10-09
 */
@RestController
@Api(tags = "动态表单实例Api")
@RequestMapping(value = "/form-instance", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FormInstanceController extends AbstractBaseController {


    @Autowired
    private IFormInstanceService formInstanceService;

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "通过分组code查询列及值信息", notes = "通过分组code查询列及值信息")
    @RequestMapping(value = "/queryColumnAndValueByGroup", method = RequestMethod.GET)
    public List<FormGroupColumnDto> queryColumnAndValueByGroup(@RequestParam String groupCode, @RequestParam(required = false) Long instanceId) {
        return formInstanceService.queryColumnAndValueByGroup(groupCode, instanceId);
    }

}


