package com.yeejoin.amos.api.openapi.util;

import java.util.Arrays;

public class MultiFieldKey {
    private final Object[] fields;

    public MultiFieldKey(Object... fields) {
        this.fields = fields.clone();
    }

    public Object getField(int index) {
        return fields[index];
    }

    // 可能需要重写equals和hashCode方法来确保正确的比较行为
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MultiFieldKey that = (MultiFieldKey) o;
        return Arrays.equals(fields, that.fields);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(fields);
    }
}

