package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.Getter;

import java.util.*;

@Getter
public enum UnitTypeEnum {
    //type 1生产单位 2使用单位 3充装单位 4检验检测机构
    //制造单位
    ZZDW("制造单位","1236","1","生产单位"),
    //设计单位
    SJDW("设计单位","1235","1","生产单位"),
    //安改维单位
    AGWDW("安装改造维修单位","1234","1","生产单位"),
    //使用单位
    SYDW("使用单位","1232","2","使用单位"),
    //使用单位
    GRZT("个人主体","6601","2","使用单位"),
    //充装单位
    CZDW("充装单位","1231","3","充装单位"),
    //检验检测机构
    JYJG("检验机构","1233-1","4","检验机构"),
    JCJG("检测机构", "1233-2", "5", "检测机构"),
    ;

    String name;
    String code;
    String type;
    String typeName;

    private UnitTypeEnum(String name, String code, String type,String typeName) {
        this.name = name;
        this.code = code;
        this.type = type;
        this.typeName = typeName;
    }

    public static List<String> getNameListByType(String type) {
        List<String> list = new ArrayList<>();
        for (UnitTypeEnum testEnum : EnumSet.allOf(UnitTypeEnum.class)) {
            if (testEnum.getType().equals(type)) {
                list.add(testEnum.getName());
            }
        }
        return list;
    }

    public static List<Map<String, String>> getTypeNameList(){
        List<Map<String,String>> list = new ArrayList<>();
        Map<String,String> map = new HashMap<>();
        for (UnitTypeEnum testEnum : EnumSet.allOf(UnitTypeEnum.class)) {
            if(!map.containsKey(testEnum.type)){
                Map<String,String> enumMap = new HashMap<>();
                enumMap.put("title",testEnum.typeName);
                enumMap.put("value",testEnum.type);
                map.put(testEnum.type, testEnum.getTypeName());
                list.add(enumMap);
            }
        }
        return list;
    }
}
