package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.scrapCancel;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgScrapCancel;
import com.yeejoin.amos.boot.module.jg.api.entity.JgScrapCancelEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgScrapCancelEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgScrapCancelServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class ScrapCancelEditUpdateService {

    private final JgScrapCancelServiceImpl mainService;

    private final JgScrapCancelEqServiceImpl eqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgScrapCancel jgScrapCancel = mainService.getOne(new LambdaQueryWrapper<JgScrapCancel>().eq(JgScrapCancel::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
        List<JgScrapCancelEq> eqs = eqService.list(new LambdaQueryWrapper<JgScrapCancelEq>().eq(JgScrapCancelEq::getEquipTransferId, jgScrapCancel.getSequenceNbr()).select(JgScrapCancelEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgScrapCancelEq::getEquId).collect(Collectors.toSet());
    }

    public JgScrapCancel getOneByApplyNo(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgScrapCancel>().eq(JgScrapCancel::getApplyNo, applyNo));
    }

}