package com.yeejoin.amos.patrol.business.service.intfc;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import com.yeejoin.amos.patrol.business.entity.mybatis.TaskBo;
import com.yeejoin.amos.patrol.business.param.TaskPageParam;
import com.yeejoin.amos.patrol.business.param.TaskParam;
import com.yeejoin.amos.patrol.business.param.TaskStatisticsParam;
import com.yeejoin.amos.patrol.business.util.DaoCriteria;
import com.yeejoin.amos.patrol.business.vo.TaskStatisticsVo;
import com.yeejoin.amos.patrol.dao.entity.Task;
import com.yeejoin.amos.patrol.dao.entity.TaskFeedback;
import com.yeejoin.amos.patrol.dao.entity.TaskPicture;
import org.quartz.JobDataMap;
import org.springframework.data.domain.Page;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 	巡检任务业务处理接口
 * @author gaodongdong
 *
 */
public interface ITaskService {
	/**
	 * 	新增任务
	 * @param param 任务
	 * @param user 用户信息
	 * @return
	 */
	public Long addNewTask(TaskParam param);

	/**
	 *   	查询任务详情
	 * @param taskID
	 * @return
	 */
	public TaskBo queryTaskDetail(Long taskID);

	/**
	 * 	修改任务
	 *
	 * @param param 任务
	 * @param user 用户信息
	 */
	public void updateTask(TaskParam param);

	/**
	 * 	 删除任务
	 *
	 * @param taskID
	 * @return
	 */
	public void delTask(Long taskID);

	/**
	 * 	回复任务
	 * @param pictures
	 *
	 * @param TaskFeedback
	 */
	public Task feedbackTask(TaskFeedback taskFeedback, List<TaskPicture> pictures);

	/**
	 * 	转发任务
	 * @param task
	 * @param user
	 * @param userId
	 */
	public void forwardTask(String toke,String product,String appKey,Long taskId, AgencyUserModel user, String targetUserId) throws Exception;

	/**
	 * 	分页条件查询任务
	 * @return
	 */
	public Page<HashMap<String,Object>> queryTaskByPage(String toke,String product,String appKey,TaskPageParam param);

	/**
	 * 	条件查询任务
	 * @param params
	 * @return
	 */
	public List<Task> queryTaskByCondition(List<DaoCriteria> criterias);

	/**
	 * 	条件查询任务个数
	 * @param params
	 * @return
	 */
	public int queryTaskCountByCondition(List<DaoCriteria> criterias);

	/**
	 *  批量删除任务
	 * @param taskIDs
	 */
	public void batchDelTask(String taskIDs);

	/**
	 * 	跟新任务状态
	 * @param taskIds
	 * @param status
	 * @param orgCode
	 * @param user
	 */
	public void handleTask(String taskIds, int status, AgencyUserModel user, String orgCode);

	/**
	 * 	手机app获取任务图表数据
	 * @param request
	 * @return
	 */
	public Map queryTaskCharts(HashMap<String, Object> request);


	public String job(JobDataMap jobDataMap);

	/**
	 * 	手机根据条件查询任务
	 * @param request
	 * @return
	 */
	public List<Map> queryTasks(HashMap<String, Object> request);

	public HashMap<String, List<HashMap<String, Object>>> getHiddenDangerCountData(HashMap<String, Object> params);


	/**
	 * 根据巡检路线IDs获取对应路线上的所有点ID
	 * @param routeID
	 * @return
	 */
	List<HashMap<String, Object>> getPointIDsByRouteIDs(List<String> routeID);

	public Map<String, Object> getTaskForAppPie(HashMap<String, Object> params);

	/**
	 * 根据条件统计任务
	 * @param param
	 * @return
	 */
	public List<TaskStatisticsVo> getTaskStatistics(TaskStatisticsParam param);

	/**
	 * 获取公司任务完成情况
	 * @param loginOrgCode
	 * @return
	 */
	public String getTaskFinishCountByOrgCode(String loginOrgCode);


	public List<TaskFeedback> queryTaskRecord(Long taskID);

	/**
	 * 查询检查项不合格任务详情
	 * @param checkId
	 * @param taskId
	 * @return
	 */
	public Map<String, Object> queryCheckTaskDetail(long checkId, long taskId);

	/**
	 * 同步手机离线任务
	 * @param user
	 * @return
	 */
	public List<Map<String, Object>> synchronizedOfflineTasks(AgencyUserModel user, ReginParams reginParams);


	/**
	 * 图片上传
	 *
	 * @return*/
	Map<String, String> uploadFile(MultipartFile file);
}
