package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author system_generator
 * @date 2024-07-03
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="JgUseRegistrationManageDto", description="")
public class JgUseRegistrationManageDto extends BaseDto {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "使用登记证状态（已登记，已注销）")
    private String certificateStatus;

    @ApiModelProperty(value = "接收机构/登记机关")
    private String receiveOrgName;

    @ApiModelProperty(value = "办理日期")
    private String auditPassDate;

    @ApiModelProperty(value = "登记类别")
    private String regType;

    @ApiModelProperty(value = "申请日期")
    private String regDate;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "设备种类编码")
    private String equListCode;

    @ApiModelProperty(value = "设备类别编码")
    private String equCategoryCode;

    @ApiModelProperty(value = "设备品种编码")
    private String equDefineCode;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    private String createDate;

    @ApiModelProperty(value = "使用登记证编号")
    private String useRegistrationCode;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "原使用单位统一信用代码")
    private String originalUseUnitCreditCode;

    @ApiModelProperty(value = "接收机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "登记证书编号/登记证书唯一码")
    private String certificateNo;

    @ApiModelProperty(value = "数据类型：监管/行政审批局，企业")
    private String dataType;

    @ApiModelProperty(value = "车牌号-车用气瓶登记")
    private String carNumber;

    @ApiModelProperty(value = "设备使用地址")
    private String equUseAddress;

    @ApiModelProperty(value = "使用单位地址")
    private String useUnitAddress;

    @ApiModelProperty("使用登记办理类型，unit单位, set台套")
    private String manageType;

    @ApiModelProperty(value = "使用单位统一信用代码-搜索使用")
    private String useUnitCreditCodeForSearch;

    @ApiModelProperty(value = "是否车用气瓶--过滤数据使用")
    private String whetherVehicleCylinder;

    @ApiModelProperty(value = "是否气瓶--过滤数据使用   ---目前使用场景：注销报废业务 值为true 只过滤出气瓶的使用登记证）")
    private String isCyl;

    @ApiModelProperty(value = "是否报废状态：1报废 0 未报废 ---目前使用场景：非单位业务办理报废业务，筛选出非报废状态的证--过滤数据使用）")
    private String isScrap;

    @ApiModelProperty(value = "业务类型code，报废业务使用")
    private String applyType;

    @ApiModelProperty(value = "城市名称")
    private String cityName;

    @ApiModelProperty(value = "登记版本号")
    private Integer version;

    @ApiModelProperty(value = "变更原因")
    private String changeReason;

    @ApiModelProperty(value = "是否超设计使用年限（0-否，1-是）")
    private String isOverDesign;

    @ApiModelProperty("补证日期")
    private Date reissueDate;

    @ApiModelProperty("是否在流程中,值：true / false ")
    private String certInBusinessFlag;

    @ApiModelProperty("管辖机构")
    private String superviseOrgCode;

    @ApiModelProperty("管辖机构名称")
    private String superviseOrgName;

    @ApiModelProperty("是否可以做业务-西安电梯导入用（0-否，1-是）")
    private String isDoBusiness;
}
