package com.yeejoin.amos.api.openapi.feign;


import com.yeejoin.amos.api.openapi.config.FeignConfiguration;
import com.yeejoin.amos.api.openapi.face.dto.JyjcInspectionResultDataModel;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

@FeignClient(name = "TZS-JYJC", path = "/jyjc", configuration = {FeignConfiguration.class})
public interface JyjcServiceFeignClient {


    /**
     * 报检结果接收
     *
     * @param resultDataModels 请求体
     * @return 是否成功
     */
    @RequestMapping(value = "/jyjc-inspection-result/receive", method = RequestMethod.POST)
    ResponseModel<List<JyjcInspectionResultDataModel>> saveResultDataBatch(@RequestBody List<JyjcInspectionResultDataModel> resultDataModels);

}
