package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 安全追溯-起重机械
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@Group("4000")
public class LiftingTechParamDefine implements ITechParamDefine {


    @TechnicalParameter(key = "ratedLoadCapacity", label = "额定载重量", equCategory = {"4800", "4D00"}, equDefine = {"4860"}, ignoreCategoryConf = {"4800"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "Kg")
    private BigDecimal ratedLoadCapacity;

    @TechnicalParameter(key = "ratedLiftingCapacity", label = "额定起重量", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00", "4300"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4310", "4320", "4410", "4420", "4440", "4450", "4870", "4170"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "t")
    private BigDecimal ratedLiftingCapacity;


    @TechnicalParameter(key = "maxLiftingCapacity", label = "最大起重量", equCategory = {"4700"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "t")
    private BigDecimal maxLiftingCapacity;


    @TechnicalParameter(key = "maxLiftingTorque", label = "最大起重力矩", equCategory = {"4700"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "KN.m")
    private BigDecimal maxLiftingTorque;


    @TechnicalParameter(key = "spanWorkingRange", label = "跨度（工作幅度）", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00", "4300", "4700"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4310", "4320", "4410", "4420", "4440", "4450", "4710", "4760", "4870", "4170"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal spanWorkingRange;


    @TechnicalParameter(key = "liftingSpeed", label = "起升速度", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00", "4300", "4700"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4310", "4320", "4410", "4420", "4440", "4450", "4710", "4760", "4870", "4170"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal liftingSpeed;


    @TechnicalParameter(key = "liftingHeight", label = "起升高度", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00", "4700"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4410", "4420", "4440", "4450", "4710", "4760", "4870", "4170"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal liftingHeight;


    @TechnicalParameter(key = "workLevel", label = "工作级别", type = TechnicalParameter.ParamType.STRING, dictCode = "GZJB")
    private String workLevel;


    @TechnicalParameter(key = "ratedLiftingTorque", label = "额定起重力矩", equCategory = {"4300"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "KN.m")
    private BigDecimal ratedLiftingTorque;


    @TechnicalParameter(key = "numberStorey", label = "层数/泊位数", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "层")
    private BigDecimal numberStorey;


    @TechnicalParameter(key = "runningSpeed", label = "运行速度", equCategory = {"4700"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal runningSpeed;


    @TechnicalParameter(key = "bigcarRunSpeed", label = "大车运行速度", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4410", "4420", "4440", "4450", "4870", "4170"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal bigcarRunSpeed;


    @TechnicalParameter(key = "smallcarrunSpeed", label = "小车运行速度", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4410", "4420", "4440", "4450", "4870", "4170"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal smallcarrunSpeed;


    @TechnicalParameter(key = "ratedMembers", label = "额定乘员数", equCategory = {"4800"}, equDefine = {"4860"}, ignoreCategoryConf = {"4800"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "人")
    private BigDecimal ratedMembers;


    @TechnicalParameter(key = "ratedLiftingSpeed", label = "额定提升速度", equCategory = {"4800"}, equDefine = {"4860"}, ignoreCategoryConf = {"4800"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal ratedLiftingSpeed;


    @TechnicalParameter(key = "heightFreeEnd", label = "自由端高度", equCategory = {"4800"}, equDefine = {"4860"}, ignoreCategoryConf = {"4800"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal heightFreeEnd;


    @TechnicalParameter(key = "workStrokeCage", label = "吊笼工作行程", equCategory = {"4800"}, equDefine = {"4860"}, ignoreCategoryConf = {"4800"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal workStrokeCage;


    @TechnicalParameter(key = "storageCapacity", label = "存容量", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "辆")
    private BigDecimal storageCapacity;


    @TechnicalParameter(key = "ratedLiftSpeed", label = "额定升降速度", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal ratedLiftSpeed;


    @TechnicalParameter(key = "ratedTraverseSpeed", label = "额定横移速度", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal ratedTraverseSpeed;


    @TechnicalParameter(key = "explosionProofGrade", label = "区域防爆等级", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4410", "4420", "4440", "4450", "4870", "4170"}, type = TechnicalParameter.ParamType.STRING, dictCode = "FBDJ")
    private String explosionProofGrade;


    @TechnicalParameter(key = "cantileverLength", label = "悬臂长度", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4410", "4420", "4440", "4450", "4870", "4170"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal cantileverLength;

    @TechnicalParameter(key = "derrickingSpeed", label = "变幅速度", equCategory = {"4300", "4700"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m/min")
    private BigDecimal derrickingSpeed;


    @TechnicalParameter(key = "hangingCagesNumber", label = "吊笼数量", equCategory = {"4800"}, equDefine = {"4860"}, ignoreCategoryConf = {"4800"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "个")
    private BigDecimal hangingCagesNumber;


    @TechnicalParameter(key = "explosiveSubstance", label = "燃爆物质", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4410", "4420", "4440", "4450", "4870", "4170"}, type = TechnicalParameter.ParamType.STRING)
    private String explosiveSubstance;

//    附件上传类型的参数，无法参与查询，暂时注释掉
//    @TechnicalParameter(key = "explosionproofSignComplete", label = "整机防爆标志", equCategory = {"4100", "4200", "4400", "4800", "4900", "4A00"}, equDefine = {"4110", "4130", "4140", "4150", "4190", "4210", "4220", "4230", "4240", "4250", "4260", "4270", "4280", "4290", "4410", "4420", "4440", "4450", "4870", "4170"}, type = TechnicalParameter.ParamType.STRING)
//    private String explosionproofSignComplete;


    @TechnicalParameter(key = "checkFinishedHeight", label = "监检结束高度", equCategory = {"4300", "4800"}, ignoreCategoryConf = {"4800"}, equDefine = {"4310", "4320", "4860"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal checkFinishedHeight;


    @TechnicalParameter(key = "parkingVehicleHeight", label = "适停车辆尺寸高", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.STRING, unit = "m")
    private String parkingVehicleHeight;


    @TechnicalParameter(key = "parkingVehicleWeight", label = "适停车辆尺寸宽", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.STRING, unit = "m")
    private String parkingVehicleWeight;


    @TechnicalParameter(key = "parkingVehicleLength", label = "适停车辆尺寸长", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.STRING, unit = "m")
    private String parkingVehicleLength;



    @TechnicalParameter(key = "maxSpanWorkingRange", label = "最大工作幅度", equCategory = {"4300", "4700"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal maxSpanWorkingRange;


    @TechnicalParameter(key = "minSpanWorkingRange", label = "最小工作幅度", equCategory = {"4300", "4700"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "m")
    private BigDecimal minSpanWorkingRange;


    @TechnicalParameter(key = "bicycleMaxComeExitTime", label = "单车最大进（出）车时间", equCategory = {"4D00"}, type = TechnicalParameter.ParamType.BIG_DECIMAL, unit = "s")
    private BigDecimal bicycleMaxComeExitTime;
}


