package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-锅炉
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "tech_params_boiler")
public class TechParamsBoilerChangeFieldDto extends BaseTechParamsFieldDto {

    @FieldDisplayDefine(value = "设备级别", dictCode = "GLJB")
    private String deviceLevel;

    @FieldDisplayDefine(value = "额定蒸发量（热功率）")
    private String ratedEvaporationCapacityThermalPower;

    @FieldDisplayDefine(value = "额定工作压力")
    private String ratedWorkingPressure;

    @FieldDisplayDefine(value = "额定工作温度")
    private String ratedOperatingTemperature;

    @FieldDisplayDefine(value = "设计热效率")
    private String designThermalEfficiency;

    @FieldDisplayDefine(value = "给水温度")
    private String feedwaterTemperature;

    @FieldDisplayDefine(value = "额定出/回水(油)温度")
    private String ratedOutletReturnWaterOilTemperature;

    @FieldDisplayDefine(value = "锅炉本体水（油）容积")
    private String waterOilVolumeOfBoilerProper;

    @FieldDisplayDefine(value = "整装锅炉本体液压试验介质/压力")
    private String hydraulicTestMediumPressureOfPackagedBoilerBody;

    @FieldDisplayDefine(value = "再热器进（出）口温度")
    private String inletOutletTemperatureOfReheater;

    @FieldDisplayDefine(value = "再热器进（出）口压力")
    private String reheaterInletOutletPressure;

    @FieldDisplayDefine(value = "再热蒸汽流量")
    private String reheatSteamFlow;

    @FieldDisplayDefine(value = "有机热载体锅炉气密试验介质/压力")
    private String glAirtightTest;

    @FieldDisplayDefine(value = "燃料（热源）种类", dictCode = "GLZL")
    private String fuelType;

    @FieldDisplayDefine(value = "受压部件名称", dictCode = "GLBJMC")
    private String nameOfPressureParts;

    @FieldDisplayDefine(value = "受压部件材料")
    private String materialOfPressureParts;

    @FieldDisplayDefine(value = "受压部件壁厚")
    private String wallThicknessOfPressureParts;

    @FieldDisplayDefine(value = "受压部件无损检测方法", dictCode = "GLWSJCFF")
    private String nonDestructiveTestingMethodsForPressureParts;

    @FieldDisplayDefine(value = "受压部件无损检测比例")
    private String proportionOfNdtForPressureParts;

    @FieldDisplayDefine(value = "受压部件热处理温度")
    private String heatTreatmentTemperatureOfPressureParts;

    @FieldDisplayDefine(value = "受压部件热处理时间")
    private String heatTreatmentTimeOfPressureParts;

    @FieldDisplayDefine(value = "受压部件水（耐）压试验介质")
    private String hydrostaticTestMedium;

    @FieldDisplayDefine(value = "受压部件水（耐）压试验压力")
    private String hydrostaticTestPressure;

    @FieldDisplayDefine(value = "燃烧方式")
    private String combustionMode;

    @FieldDisplayDefine(value = "安全阀效验报告编号")
    private String safetyValveVerificationReportNo;


    @FieldDisplayDefine(value = "安全阀整定压力")
    private String safetyValveSettingPressure;


    @FieldDisplayDefine(value = "水处理定期检验报告编号")
    private String waterTreatmentRegularInspectionReportNo;

    @FieldDisplayDefine(value = "水处理定期检验结论")
    private String waterTreatmentRegularInspectionResult;


    @FieldDisplayDefine(value = "能效测试报告编号")
    private String energyEfficiencyTestReportNo;

}
