package com.yeejoin.amos.boot.module.jg.biz.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.api.dto.JgScrapCancelDto;
import com.yeejoin.amos.boot.module.jg.api.enums.WorkFlowStatusEnum;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgScrapCancelServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.*;

/**
 * 设备报废注销
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "设备报废注销Api")
@RequestMapping(value = "/jg-scrap-cancel")
public class JgScrapCancelController extends BaseController {

    @Autowired
    JgScrapCancelServiceImpl jgScrapCancelService;

    @Autowired
    IJgInstallationNoticeService iJgInstallationNoticeService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "暂存、工作台提交", notes = "暂存、工作台提交")
    public ResponseModel<Object> save(@RequestParam String submitType, @RequestBody Map<String, Object> model) {
        return ResponseHelper.buildResponse(jgScrapCancelService.save(submitType, model));
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param model 安装告知
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/updateInfo")
    @ApiOperation(httpMethod = "POST", value = "保存、保存并提交、提交", notes = "保存、保存并提交、提交")
    public ResponseModel<JgScrapCancelDto> updateInfo(@RequestParam String submitType,
                                                      @RequestBody Map<String, Object> model,
                                                      @RequestParam(value = "op", required = false) String op) {

        JgScrapCancelDto jgScrapCancelDto = JSON.parseObject(JSON.toJSONString(model.get("jgScrapCancelAdd")), JgScrapCancelDto.class);
        if (Objects.isNull(jgScrapCancelDto)) {
            throw new IllegalArgumentException("参数jgScrapCancelAdd不能为空");
        }
        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(model.get("jgScrapCancelAdd")));
        jgScrapCancelDto.setSEQUENCE_NBR(String.valueOf(jsonObject.get("record")));
        return ResponseHelper.buildResponse(jgScrapCancelService.updateInfo(submitType, jgScrapCancelDto, op, jsonObject));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/flowExecute")
    @ApiOperation(httpMethod = "POST", value = "执行流程", notes = "执行流程")
    public ResponseModel<Object> flowExecute(@RequestBody JSONObject map) {

        LinkedHashMap<?, ?> model1 = (LinkedHashMap<?, ?>) map.get("model");
        LinkedHashMap<?, ?> jgScrapCancelInfo = (LinkedHashMap<?, ?>) model1.get("jgScrapCancelAdd");
        jgScrapCancelInfo.remove("SEQUENCE_NBR");
        JgScrapCancelDto jgScrapCancelDto = JSON.parseObject(JSON.toJSONString(jgScrapCancelInfo), JgScrapCancelDto.class);

        jgScrapCancelService.flowExecute(jgScrapCancelDto.getEquListCode(),
                Long.valueOf(String.valueOf(jgScrapCancelDto.getSequenceNbr())),
                jgScrapCancelDto.getInstanceId(),
                String.valueOf(map.get("operate")),
                String.valueOf(map.get("opinion")),
                String.valueOf(map.get("nextTaskId")));
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteBatch")
    @ApiOperation(httpMethod = "POST", value = "批量删除", notes = "批量删除")
    public ResponseModel<Object> deleteBatch(@RequestBody JSONObject map) {
        List<Long> ids = (List<Long>) map.get("ids");
        jgScrapCancelService.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/deleteMessage")
    @ApiOperation(httpMethod = "POST", value = "单个删除", notes = "单个删除")
    public ResponseModel<Object> deleteMessage(@RequestParam("id") Long id) {
        List<Long> ids = Collections.singletonList(id);
        jgScrapCancelService.deleteBatch(ids);
        return ResponseHelper.buildResponse("ok");
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "POST", value = "分页查询", notes = "分页查询")
    @PostMapping(value = "/getList")
    public ResponseModel<Page<JgScrapCancelDto>> getList(JgScrapCancelDto dto,
                                                         @RequestParam(value = "sort", required = false) String sort,
                                                         @RequestParam(value = "current") int current,
                                                         @RequestParam(value = "size") int size,
                                                         @ApiParam(value = "客户端类型: jgAudit-监管审核;jgLook-监管查看") @RequestParam(value = "client", required = false, defaultValue = "jgAudit") String client
    ) {
        Page<JgScrapCancelDto> page = new Page<>(current, size);
        dto.setType(String.valueOf(iJgInstallationNoticeService.getCompanyType().get("companyLevel")));
        return ResponseHelper.buildResponse(jgScrapCancelService.getList(dto, sort, page, dto.getRoleIds(), client));
    }


    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/details")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个详情", notes = "根据sequenceNbr查询单个详情")
    public ResponseModel<Map<String, Object>> selectOne(@RequestParam("sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(jgScrapCancelService.queryBySequenceNbr(sequenceNbr, getSelectedOrgInfo().getCompany()));
    }


    /**
     * 撤回
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/withdraw")
    @ApiOperation(httpMethod = "POST", value = "撤回", notes = "撤回")
    public ResponseModel<Object> revocation(@RequestBody JSONObject map) {
        jgScrapCancelService.revocation(String.valueOf(map.get("instanceId")), String.valueOf(map.get("nextTaskId")));
        return ResponseHelper.buildResponse("ok");
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表筛选办理状态下拉", notes = "列表筛选办理状态下拉")
    @GetMapping(value = "/getAuditStatusList")
    public ResponseModel<List<Map<String, String>>> getAuditStatusList(@RequestParam(value = "code") String code) {
        return ResponseHelper.buildResponse(WorkFlowStatusEnum.getInfoList(code));
    }


    /**
     * 处理设备报废注销流程结束，业务未结束单子问题
     * @param applyNo 申请单号
     * @return s
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/handleNoticeWrongData")
    @ApiOperation(httpMethod = "POST", value = "处理设备报废注销流程结束，业务未结束单子问题", notes = "处理设备报废注销流程结束，业务未结束单子问题")
    public ResponseModel<Object> handleScrapCancelWrongData(@RequestParam("applyNo") String applyNo) {
        jgScrapCancelService.handleScrapCancelWrongData(applyNo);
        return ResponseHelper.buildResponse("ok");
    }
}
