package com.yeejoin.amos.boot.module.common.api.enums;

import lombok.Getter;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

@Getter
public enum IssueProblemLevelEnum {
    LEVEL_ONE("一级","1"),
    LEVEL_TWO("二级","2"),
    LEVEL_THREE("三级","3"),
    ;


    String name;
    String code;

    private IssueProblemLevelEnum(String name, String code) {
        this.name = name;
        this.code = code;
    }

    public static List<HashMap<String,String>> getEnumList() {
        List<HashMap<String, String>> list = new ArrayList<>();
        for (IssueProblemLevelEnum testEnum : EnumSet.allOf(IssueProblemLevelEnum.class)) {
            HashMap<String, String> map = new HashMap<>();
            map.put(testEnum.name,testEnum.code.toString());
            list.add(map);
        }
        return list;
    }

}
