package com.yeejoin.amos.boot.module.jg.biz.factory;

import com.yeejoin.amos.boot.module.jg.api.dto.*;

import java.util.HashMap;
import java.util.Map;

public class ChangeItemFactory {

    private static final Map<String, Class<? extends BaseChangeDataDto>> ITEM_FACTORY = new HashMap<>();

    static {
        // 使用信息
        ITEM_FACTORY.put("equip_use_info", EquipUseInfoChangeDataDto.class);
        // 设备-注册登记信息
        ITEM_FACTORY.put("equip_register_info", EquipRegisterChangeDataDto.class);
        // 设备-制造信息
        ITEM_FACTORY.put("equip_factory_info", EquipFactoryChangeDataDto.class);
        // 设备-设计信息
        ITEM_FACTORY.put("equip_design_info", EquipDesignChangeDataDto.class);
    }

    public static Class<? extends BaseChangeDataDto> getItemGroupClass(String group) {
        return ITEM_FACTORY.get(group);
    }

}
