package com.yeejoin.amos.api.openapi.face.dto;

import com.yeejoin.amos.api.openapi.face.orm.entity.DesignInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MiddMainParts;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidMaintenanceInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipOtherInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipProduceInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipProtectionDevices;
import com.yeejoin.amos.api.openapi.face.orm.entity.MidEquipRegistrationInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MiddEquipSuperviseInfo;
import com.yeejoin.amos.api.openapi.face.orm.entity.MiddEquipUseInfo;
import lombok.Data;

import java.util.List;
import java.util.Map;

/**
 * 监管设备信息
 * */
@Data
public class EquipmentInfoDto {

	/**
	 * 使用信息
	 */
	private MiddEquipUseInfo useInfo;

	/**
	 * 设计制造
	 */
	private DesignInfo designInfo;

	/**
	 * 制造信息
	 */
	private MidEquipProduceInfo factoryInfo;

	/**
	 * 监管信息
	 */
	private MiddEquipSuperviseInfo supervisionInfo;

	/**
	 * 注册登记
	 */
	private MidEquipRegistrationInfo registerInfo;

	/**
	 * 维保备案
	 */
	private MidMaintenanceInfo maintenanceRecordInfo;
	/**
	 * 其他信息
	 */
	private MidEquipOtherInfo otherInfo;

	/**
	 * 主要零部件
	 */
	private List<MiddMainParts> mainParts;

	/**
	 * 保护装置
	 */
	private List<MidEquipProtectionDevices> protectionDevices;

	/**
	 * 设备参数信息
	 */
	private Map<String, Object> params;

	/**
	 * 操作类型 1 新增  0 修改
	 */
	private Integer saveStatus;

	/**
	 * 监管码
	 */
	private String supervisoryCode;

}
