package com.yeejoin.amos.api.openapi.face.orm.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <p>
 * 厂(场)内机动车辆
 * </p>
 *
 * @author 子杨
 * @since 2021-12-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@TableName("tm_special_vehicle")
public class SpecialVehicle extends AbstractBaseEntity {

	private static final long serialVersionUID = 1L;
	/**
	 * 设备全省唯一编号
	 */
	@TableField("sequence_code")
	private String sequenceCode;
	/**
	 * 运行速度(km/h)
	 */
	@TableField("running_speed")
	private String runningSpeed;
	/**
	 * 最高时速(km/h)
	 */
	@TableField("top_speed")
	private String topSpeed;
	/**
	 * 额定载荷(kg)
	 */
	@TableField("rated_load")
	private String ratedLoad;
	/**
	 * 动力方式
	 */
	@TableField("power_mode")
	private String powerMode;
	/**
	 * 车牌号码
	 */
	@TableField("car_num")
	private String carNum;
	/**
	 * 驱动
	 */
	@TableField("drive")
	private String drive;
	/**
	 * 空车重量
	 */
	@TableField("empty_weight")
	private String emptyWeight;
	/**
	 * 发动机编号
	 */
	@TableField("engine_num")
	private String engineNum;
	/**
	 * 有否拖挂车
	 */
	@TableField("is_trailer")
	private String isTrailer;
	/**
	 * 设备型号/厂牌型号
	 */
	@TableField("equ_model")
	private String equModel;
	/**
	 * 座位数量
	 */
	@TableField("seat_num")
	private String seatNum;
	/**
	 * 底盘编号
	 */
	@TableField("chassis_num")
	private String chassisNum;
	/**
	 * 燃料种类
	 */
	@TableField("fuel_type")
	private String fuelType;
	/**
	 * 颜色（字典）
	 */
	@TableField("colour")
	private String colour;

}
