package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
* 值班班次
*
* @author system_generator
* @date 2021-07-06
*/
@Data
@ApiModel(value="DutyCarDto", description="值班车辆")
public class DutyCarDto implements Serializable {

   private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户id")
    private String userId;

    @ApiModelProperty(value = "用户名称")
    private String userName;

    @ApiModelProperty(value = "车辆id")
    private String carId;

    @ApiModelProperty(value = "车辆名称")
    private String carName;

    @ApiModelProperty(value = "消防队伍id")
    private String teamId;

    @ApiModelProperty(value = "消防队伍名称")
    private String teamName;

    @ApiModelProperty(value = "岗位id")
    private String postType;

    @ApiModelProperty(value = "岗位名称")
    private String postTypeName;

    @ApiModelProperty(value = "值班信息")
    private List<DutyPersonShiftDto> dutyShift = new ArrayList<>();
    // BUG 2807 更新人员车辆排版值班的保存逻辑 如果没有填写数据则保存空数据 。 同步修改 查询 导出相关逻辑 by kongfm 2021-09-14
    @ApiModelProperty(value = "值班开始时间")
    private String startTime;

    @ApiModelProperty(value = "值班结束时间")
    private String endTime;

    // 需求 958 新增值班区域 值班区域id 字段 前台保存字段 by kongfm 2021-09-15
    @ApiModelProperty(value = "值班区域")
    private String dutyArea;

    @ApiModelProperty(value = "值班区域Id")
    private String dutyAreaId;
}
