package com.yeejoin.amos.boot.module.common.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.common.api.entity.FeedbackReplies;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FeedbackRepliesServiceImpl;
import com.yeejoin.amos.boot.module.common.biz.service.impl.FeedbackSuggestionsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;

/**
 * @author system_generator
 * @date 2025-05-15
 */
@RestController
@Api(tags = "反馈回复表")
@RequestMapping(value = "/feedback-replies")
public class FeedbackRepliesController extends BaseController {

    @Autowired
    FeedbackRepliesServiceImpl feedbackRepliesServiceImpl;
    @Autowired
    FeedbackSuggestionsServiceImpl feedbackSuggestionsService;

    /**
     * 根据suggestion seq查询
     *
     * @param suggestSeq suggestion主键
     * @return result
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getRepliesListBySugSeq")
    @ApiOperation(httpMethod = "GET", value = "根据反馈建议表sequenceNbr查询回复列表", notes = "根据反馈建议表sequenceNbr查询回复列表")
    public ResponseModel<List<FeedbackReplies>> getRepliesListBySugSeq(@RequestParam("suggestSeq") Long suggestSeq) {
        return ResponseHelper.buildResponse(feedbackRepliesServiceImpl.getRepliesListBySugSeq(suggestSeq));
    }

    /**
     * 监管机构回复
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/save")
    @ApiOperation(httpMethod = "POST", value = "监管机构回复", notes = "监管机构回复")
    public ResponseModel<FeedbackReplies> save(@RequestBody FeedbackReplies feedbackReplies) {
        if (feedbackReplies.getReplyDescription() == null || feedbackReplies.getReplyDescription().isEmpty()
                || feedbackReplies.getSuggestionsSeq() == null || feedbackReplies.getSuggestionsSeq().isEmpty()
        ) {
            throw new BadRequest("缺少必要参数");
        }
        ReginParams reginParams = getSelectedOrgInfo();
        return ResponseHelper.buildResponse(feedbackRepliesServiceImpl.saveReplies(reginParams, feedbackReplies));
    }

    /**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PutMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新", notes = "根据sequenceNbr更新")
    public ResponseModel<FeedbackReplies> updateBySequenceNbrFeedbackReplies(@RequestBody FeedbackReplies entity, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        entity.setSequenceNbr(sequenceNbr);
        return ResponseHelper.buildResponse(feedbackRepliesServiceImpl.updateWithModel(entity));
    }

    /**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除", notes = "根据sequenceNbr删除")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        FeedbackReplies replies = feedbackRepliesServiceImpl.lambdaQuery()
                .eq(FeedbackReplies::getSequenceNbr, sequenceNbr)
                .one();
        String userId = getSelectedOrgInfo().getUserModel().getUserId();
        if (!ValidationUtil.isEmpty(replies) && !userId.equals(replies.getReplyUserId())) {
            throw new BadRequest("无法删除其他人的回复！");
        }
        return ResponseHelper.buildResponse(feedbackRepliesServiceImpl.deleteBySeq(sequenceNbr));
    }

    /**
     * 已读回复
     *
     * @param sequenceNbrs 回复数据seqs
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/read")
    @ApiOperation(httpMethod = "GET", value = "已读回复", notes = "已读回复")
    public ResponseModel<Boolean> selectOne(@RequestParam("sequenceNbrs") String sequenceNbrs) {
        feedbackRepliesServiceImpl.lambdaUpdate()
                .in(FeedbackReplies::getSequenceNbr, Arrays.asList(sequenceNbrs.split(",")))
                .set(FeedbackReplies::getReadStatus, "1")
                .update();
        return ResponseHelper.buildResponse(Boolean.TRUE);
    }

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "根据sequenceNbr查询单个", notes = "根据sequenceNbr查询单个")
    public ResponseModel<FeedbackReplies> selectOne(@PathVariable Long sequenceNbr) {
        return ResponseHelper.buildResponse(feedbackRepliesServiceImpl.queryBySeq(sequenceNbr));
    }

    /**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/page")
    @ApiOperation(httpMethod = "GET", value = "分页查询", notes = "分页查询")
    public ResponseModel<Page<FeedbackReplies>> queryForPage(@RequestParam(value = "current") int current, @RequestParam
            (value = "size") int size) {
        Page<FeedbackReplies> page = new Page<FeedbackReplies>();
        page.setCurrent(current);
        page.setSize(size);
        return ResponseHelper.buildResponse(feedbackRepliesServiceImpl.queryForFeedbackRepliesPage(page));
    }

    /**
     * 列表全部数据查询
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表全部数据查询", notes = "列表全部数据查询")
    @GetMapping(value = "/list")
    public ResponseModel<List<FeedbackReplies>> selectForList() {
        return ResponseHelper.buildResponse(feedbackRepliesServiceImpl.queryForFeedbackRepliesList());
    }
}
