package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.TzsJgColumnReminderRuleServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.TzsJgColumnReminderRuleDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 字段提醒配置表
 *
 * @author system_generator
 * @date 2025-06-17
 */
@RestController
@Api(tags = "字段提醒配置表Api")
@RequestMapping(value = "/tzs-jg-column-reminder-rule")
public class TzsJgColumnReminderRuleController extends BaseController {

    @Autowired
    TzsJgColumnReminderRuleServiceImpl tzsJgColumnReminderRuleServiceImpl;

    /**
     * 新增字段提醒配置表
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增字段提醒配置表", notes = "新增字段提醒配置表")
	public ResponseModel<TzsJgColumnReminderRuleDto> save(@RequestBody TzsJgColumnReminderRuleDto model) {
	    model = tzsJgColumnReminderRuleServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新字段提醒配置表", notes = "根据sequenceNbr更新字段提醒配置表")
	public ResponseModel<TzsJgColumnReminderRuleDto> updateBySequenceNbrTzsJgColumnReminderRule(@RequestBody TzsJgColumnReminderRuleDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(tzsJgColumnReminderRuleServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除字段提醒配置表", notes = "根据sequenceNbr删除字段提醒配置表")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(tzsJgColumnReminderRuleServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个字段提醒配置表",  notes = "根据sequenceNbr查询单个字段提醒配置表")
	public ResponseModel<TzsJgColumnReminderRuleDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(tzsJgColumnReminderRuleServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "字段提醒配置表分页查询",  notes = "字段提醒配置表分页查询")
	public ResponseModel<Page<TzsJgColumnReminderRuleDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<TzsJgColumnReminderRuleDto> page = new Page<TzsJgColumnReminderRuleDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(tzsJgColumnReminderRuleServiceImpl.queryForTzsJgColumnReminderRulePage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "字段提醒配置表列表全部数据查询",   notes = "字段提醒配置表列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<TzsJgColumnReminderRuleDto>> selectForList() {
	    return ResponseHelper.buildResponse(tzsJgColumnReminderRuleServiceImpl.queryForTzsJgColumnReminderRuleList());
	}
}
