package com.yeejoin.amos.boot.module.statistics.api.enums;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.annotation.TechnicalParameter;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.springframework.data.elasticsearch.annotations.FieldType;

import java.util.HashMap;
import java.util.Map;

@AllArgsConstructor
@Getter
public enum CompanyAdvanceSearchEnum {

    /**
     * 高级搜索枚举
     */
    USEUNIT("企业名称", "useUnit", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Text),
    ADDRESS("详细地址", "address", TechnicalParameter.ParamType.STRING, "", null, null, FieldType.Text),
    EXPIRYDATE("许可有效期", "expiryDate", TechnicalParameter.ParamType.DATE, "", null, null, FieldType.Date),
    UNIT_TYPE("企业类型", "unitType", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryUnitType", null, null, FieldType.Text),
    REGULATORY_LABELS("监管标签", "regulatoryLabels", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryDicData?type={type}", "QYBQ", null, FieldType.Text),
    INDUSTRY_SUPERVISOR("行业主管部门", "industrySupervisor", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryDicData?type={type}", "HYZGBM", null, FieldType.Text),
    ITEM_CODE("许可项目", "itemCode", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryXK", null, null, FieldType.Text),
    SUB_ITEM_CODE("许可子项目", "subItemCode", null, "/statistics/comprehensiveStatisticalAnalysis/select/querySubXK?type={type}", null, "itemCode", FieldType.Text),
    OPERATING_STATUS("经营状态", "operatingStatus", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryDicDataNew?type={type}", "jyzt", null, FieldType.Text),
    EQUIP_CATEGORY("设备类型", "equipCategory", null, "/statistics/comprehensiveStatisticalAnalysis/select/queryEquipList", null, null, FieldType.Text),
    PERMIT_STATUS("许可状态", "permitStatus", null, "/statistics/comprehensiveStatisticalAnalysis/select/permitStatus", null, null, FieldType.Auto),

    ;

    private String name;
    private String code;
    private TechnicalParameter.ParamType paramType;
    private String url;
    private String dataKey;
    private String argKey;
    private FieldType esType;

    public static JSONArray getAll() {
        JSONArray jsonArray = new JSONArray();
        for (CompanyAdvanceSearchEnum item : values()) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("label", item.name);
            jsonObject.put("value", item.code);
            jsonObject.put("key", item.code);
            jsonObject.put("dataKey", item.dataKey);
            jsonObject.put("argKey", item.argKey);
            jsonObject.put("paramType", item.paramType);
            jsonObject.put("isMulti", false);
            if (TechnicalParameter.ParamType.BIG_DECIMAL.equals(item.paramType)) {
                jsonObject.put("type", "inputNumber");
            } else if (TechnicalParameter.ParamType.STRING.equals(item.paramType)) {
                jsonObject.put("type", "input");
            } else if (TechnicalParameter.ParamType.DATE.equals(item.paramType)) {
                jsonObject.put("type", "date");
            } else {
                jsonObject.put("type", "select");
            }
            jsonObject.put("conditions", ConditionEnum.getByCode(item.paramType));
            jsonObject.put("url", item.url);
            jsonArray.add(jsonObject);
        }
        return jsonArray;
    }


    public static Map<String, FieldType> getEsType = new HashMap<>();

    static {
        for (CompanyAdvanceSearchEnum e : CompanyAdvanceSearchEnum.values()) {
            getEsType.put(e.code, e.esType);
        }
    }
}
