package com.yeejoin.amos.boot.module.jg.biz.context;


import com.yeejoin.amos.boot.module.jg.api.dto.FlowingEquipRedisKeyDTO;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Administrator
 */
@Slf4j
public class FlowingEquipRedisContext {


    private static ThreadLocal<List<FlowingEquipRedisKeyDTO>> threadLocal = new ThreadLocal<>();

    public static List<FlowingEquipRedisKeyDTO> getContext() {
        if (threadLocal.get() == null) {
            threadLocal.set(new ArrayList<>());
        }
        return threadLocal.get();
    }

    public static void setRedisKeyInfo(FlowingEquipRedisKeyDTO redisKeyInfo) {
        getContext().add(redisKeyInfo);
    }

    public static void clean() {
        log.info("FlowingEquipRedisContext clean begin");
        if (threadLocal != null) {
            threadLocal.remove();
        }
        log.info("FlowingEquipRedisContext clean end");
    }
}
